/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.camel.generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.JET2Writer;
import org.eclipse.stp.eid.camel.components.Activator;
import org.eclipse.stp.eid.camel.generation.GenerationContext;
import org.eclipse.stp.eid.camel.generation.SpringConfig;
import org.eclipse.stp.eid.coordination.CoordinatorException;
import org.eclipse.stp.eid.coordination.ICoordinationContext;
import org.eclipse.stp.eid.coordination.ICoordinator;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentType;
import org.eclipse.stp.eid.datamodel.ESB;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.util.Cimero2EditorPlugin;
import org.eclipse.stp.eid.generation.IGenerator;
import org.eclipse.stp.eid.runtime.Runtime;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class GenerationCoordinator
implements ICoordinator {
    private File camelDirectory;

    public void run(Graph g, Resource r) {
        ICoordinationContext ctx = this.createContext(g, r);
        this.preGenerate(ctx);
        this.generate(ctx);
        this.postGenerate(ctx);
    }

    public void generate(ComponentInstance comp, ICoordinationContext ctx, JET2Writer out) {
        ESB esb = comp.getGraph().getEsb(ctx.getResource());
        Map versions = Cimero2EditorPlugin.getRuntimeRegistry().getRuntimeVersions(esb.getName());
        Runtime rt = (Runtime)versions.values().iterator().next();
        IGenerator generator = rt.getGenerator(comp.getModel().getName());
        ctx.setComponent(comp);
        generator.generate(ctx, out);
    }

    public void generate(ICoordinationContext ctx) {
        if (ctx.getGraph() == null) {
            Status camelStatus = new Status(4, this.getPluginId(), "The route graph is not valid for configuration generation at this point.");
            Activator.getDefault().getLog().log((IStatus)camelStatus);
            return;
        }
        BufferedWriter out = null;
        BodyContentWriter writer = new BodyContentWriter();
        ComponentInstance startRoute = null;
        HashMap<String, ComponentInstance> endpointMap = new HashMap<String, ComponentInstance>();
        for (ComponentInstance compo : ctx.getGraph().getComponents()) {
            if (compo.getModel().getType() != ComponentType.BC) continue;
            endpointMap.put(compo.getName(), compo);
            if (startRoute != null || compo.getSourceConnections().size() <= 0) continue;
            startRoute = compo;
        }
        ctx.getVariables().put("endpointMap", endpointMap);
        Stack<ComponentInstance> componentStack = new Stack<ComponentInstance>();
        componentStack.push(startRoute);
        ctx.getVariables().put("componentStack", componentStack);
        SpringConfig generator = new SpringConfig();
        IStatus camelStatus = null;
        try {
            try {
                generator.generate(ctx, (JET2Writer)writer);
                String generatedText = writer.toString();
                File targetFile = new File(this.camelDirectory.getAbsolutePath(), "camelContext.xml");
                out = new BufferedWriter(new FileWriter(targetFile));
                out.write(generatedText);
                camelStatus = new Status(0, this.getPluginId(), "Generation was successful");
            }
            catch (CoordinatorException cge) {
                camelStatus = cge.getStatus();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Activator.getDefault().getLog().log(camelStatus);
            }
            catch (Exception ioe) {
                block20: {
                    ioe.printStackTrace();
                    camelStatus = new Status(4, this.getPluginId(), "Failed to write configuration", (Throwable)ioe);
                    if (out == null) break block20;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Activator.getDefault().getLog().log(camelStatus);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            Activator.getDefault().getLog().log(camelStatus);
        }
    }

    public void postGenerate(ICoordinationContext ctx) {
    }

    public ICoordinationContext createContext(Graph g, Resource r) {
        return new GenerationContext(g, r, this);
    }

    public void preGenerate(ICoordinationContext ctx) {
        this.createCamelFolders(ctx.getGraph());
    }

    public void postStatus(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    private String getPluginId() {
        return "org.eclipse.stp.eid.models.camel";
    }

    private boolean createCamelFolders(Graph graph) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IEditorInput editorInput = iWorkbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IPath editorPath = ((IPathEditorInput)editorInput).getPath();
        int matchingSegs = editorPath.matchingFirstSegments(workspace.getRoot().getLocation());
        IProject proj = root.getProject(editorPath.segment(matchingSegs));
        try {
            proj.getNature("org.eclipse.pde.PluginNature");
            IResource metainf = proj.findMember("META-INF");
            this.camelDirectory = metainf != null ? new File(metainf.getLocation().toFile(), "spring") : new File(proj.getLocation().toFile(), graph.getName());
        }
        catch (CoreException ce) {
            this.camelDirectory = new File(proj.getLocation().toFile(), graph.getName());
        }
        if (!this.camelDirectory.exists()) {
            this.camelDirectory.mkdir();
        }
        return true;
    }
}

