/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.camel.generation.templates;

import java.util.Stack;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.stp.eid.ModelHelpers;
import org.eclipse.stp.eid.coordination.ICoordinationContext;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.ComponentType;

public class ContentBasedRouterGenerator
implements JET2Template {
    private ICoordinationContext coordinationContext;
    private static final String NL = System.getProperty("line.separator");

    public void generate(ICoordinationContext ctx, JET2Writer writer) {
        this.coordinationContext = ctx;
        JET2Context jctx = new JET2Context((Object)ctx.getComponent(), ctx.getVariables());
        this.generate(jctx, writer);
    }

    public void generate(JET2Context context, JET2Writer __out) {
        JET2Writer out = __out;
        ComponentInstance cbr = this.coordinationContext.getComponent();
        Stack componentStack = (Stack)context.getVariable("componentStack");
        out.write("      <choice>");
        out.write(NL);
        ComponentInstance otherwise = null;
        for (ComponentInstanceProperty prop : cbr.getProperties()) {
            if (prop.getModel().isRepeatable()) {
                ComponentInstanceProperty predicate = (ComponentInstanceProperty)prop.getSimpleSubProperties().get(0);
                ComponentInstanceProperty choice = (ComponentInstanceProperty)prop.getSimpleSubProperties().get(1);
                if (choice.getConnection() == null) {
                    context.logError("No choice connections have been made for component " + cbr.getModel().getName());
                }
                ComponentInstance target = choice.getConnection().getTarget();
                out.write("       <when>");
                out.write(NL);
                out.write("         <xpath>");
                out.write(predicate.getValue());
                out.write("</xpath>");
                out.write(NL);
                if (target.getModel().getType() == ComponentType.BC) {
                    out.write("         <to uri=\"");
                    out.write(ModelHelpers.getEndpointURI((ComponentInstance)target));
                    out.write("\" />");
                    out.write(NL);
                } else {
                    componentStack.push(cbr);
                    this.coordinationContext.getCoordinator().generate(target, this.coordinationContext, out);
                    componentStack.pop();
                }
                out.write("       </when>");
                out.write(NL);
                continue;
            }
            if (!prop.getModel().isReferenceToExternalComponent() || !prop.hasValue()) continue;
            otherwise = prop.getConnection().getTarget();
        }
        if (otherwise != null) {
            out.write("        <otherwise>");
            out.write(NL);
            if (otherwise.getModel().getType() == ComponentType.BC) {
                out.write("          <to uri=\"");
                out.write(ModelHelpers.getEndpointURI(otherwise));
                out.write("\" />");
                out.write(NL);
            } else {
                componentStack.push(cbr);
                this.coordinationContext.getCoordinator().generate(otherwise, this.coordinationContext, out);
                componentStack.pop();
            }
            out.write("        </otherwise>");
            out.write(NL);
        }
        out.write("      </choice>");
    }
}

