/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.camel.generation.templates;

import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.stp.eid.ModelHelpers;
import org.eclipse.stp.eid.coordination.ICoordinationContext;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.ComponentType;
import org.eclipse.stp.eid.datamodel.Connection;

public class MessageFilterGenerator
implements JET2Template {
    private ICoordinationContext coordinationContext;
    private static final String NL = System.getProperty("line.separator");

    public void generate(ICoordinationContext ctx, JET2Writer writer) {
        this.coordinationContext = ctx;
        JET2Context jctx = new JET2Context((Object)ctx.getComponent(), ctx.getVariables());
        this.generate(jctx, writer);
    }

    public void generate(JET2Context context, JET2Writer __out) {
        Connection next;
        JET2Writer out = __out;
        out.write(NL);
        ComponentInstance filter = this.coordinationContext.getComponent();
        Stack componentStack = (Stack)context.getVariable("componentStack");
        out.write(NL);
        out.write("      <filter>");
        out.write(NL);
        ComponentInstanceProperty xpath = null;
        for (ComponentInstanceProperty prop : filter.getProperties()) {
            if (!prop.getModel().getType().equals("String")) continue;
            xpath = prop;
            break;
        }
        if (xpath == null || xpath.getValue() == null) {
            context.logError("No XPath filter expression set for component " + filter.getModel().getName());
        }
        out.write("         <xpath>");
        out.write(xpath.getValue());
        out.write("</xpath>   ");
        out.write(NL);
        EList outgoing = filter.getSourceConnections();
        if (outgoing.isEmpty()) {
            context.logError("No outgoing connections from component " + filter.getModel().getName());
        }
        if ((next = (Connection)outgoing.get(0)).getTarget().getModel().getType() == ComponentType.BC) {
            String nextURI = ModelHelpers.getEndpointURI((ComponentInstance)next.getTarget());
            out.write("         <to uri=\"");
            out.write(nextURI);
            out.write("\" />");
            out.write(NL);
        } else {
            componentStack.push(filter);
            this.coordinationContext.getCoordinator().generate(next.getTarget(), this.coordinationContext, out);
            componentStack.pop();
        }
        out.write("       </filter> ");
    }
}

