/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.camel.generation.templates;

import java.util.Stack;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.stp.eid.ModelHelpers;
import org.eclipse.stp.eid.coordination.ICoordinationContext;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.Graph;

public class SpringWrapper
implements JET2Template {
    private ICoordinationContext coordinationContext;
    private static final String NL = System.getProperty("line.separator");

    public void generate(ICoordinationContext ctx, JET2Writer writer) {
        this.coordinationContext = ctx;
        JET2Context jctx = new JET2Context((Object)ctx.getGraph(), ctx.getVariables());
        this.generate(jctx, writer);
    }

    public void generate(JET2Context context, JET2Writer __out) {
        String endpointURI;
        JET2Writer out = __out;
        Graph graph = this.coordinationContext.getGraph();
        Stack componentStack = (Stack)context.getVariable("componentStack");
        ComponentInstance startRoute = (ComponentInstance)componentStack.peek();
        if (startRoute == null) {
            context.logError("Route graph has no starting integration endpoint");
        }
        if ((endpointURI = ModelHelpers.getEndpointURI((ComponentInstance)startRoute)) == null) {
            context.logError("Initial integration endpoint " + startRoute.getModel().getName() + " requires a URI");
        }
        out.write("<?xml version=\"1.0\"?>");
        out.write(NL);
        out.write("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
        out.write(NL);
        out.write("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        out.write(NL);
        out.write("       xsi:schemaLocation=\"");
        out.write(NL);
        out.write("       http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd");
        out.write(NL);
        out.write("       http://activemq.apache.org/camel/schema/spring http://activemq.apache.org/camel/schema/spring/camel-spring.xsd\">");
        out.write(NL);
        out.write(NL);
        out.write("  <camelContext id=\"");
        out.write(graph.getName());
        out.write("\" xmlns=\"http://activemq.apache.org/camel/schema/spring\">");
        out.write(NL);
        out.write("    <route>");
        out.write(NL);
        out.write("      <from uri=\"");
        out.write(endpointURI);
        out.write("\" />");
        out.write(NL);
        int i = 0;
        while (i < startRoute.getSourceConnections().size()) {
            ComponentInstance nextComponent = ((Connection)startRoute.getSourceConnections().get(i)).getTarget();
            this.coordinationContext.getCoordinator().generate(nextComponent, this.coordinationContext, out);
            ++i;
        }
        out.write("    </route>");
        out.write(NL);
        out.write("  </camelContext>");
        out.write(NL);
        out.write("</beans>");
        out.write(NL);
    }
}

