/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.camel.generation.templates;

import java.util.Stack;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.stp.eid.ModelHelpers;
import org.eclipse.stp.eid.coordination.ICoordinationContext;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentType;
import org.eclipse.stp.eid.datamodel.Connection;

public class WireTapGenerator
implements JET2Template {
    private ICoordinationContext coordinationContext;
    private static final String NL = System.getProperty("line.separator");

    public void generate(ICoordinationContext ctx, JET2Writer writer) {
        this.coordinationContext = ctx;
        JET2Context jctx = new JET2Context((Object)ctx.getComponent(), ctx.getVariables());
        this.generate(jctx, writer);
    }

    public void generate(JET2Context context, JET2Writer __out) {
        JET2Writer out = __out;
        out.write(NL);
        ComponentInstance wireTap = this.coordinationContext.getComponent();
        Stack componentStack = (Stack)context.getVariable("componentStack");
        for (Connection next : wireTap.getSourceConnections()) {
            ComponentInstance nextOne = next.getTarget();
            if (nextOne.getModel().getType() == ComponentType.BC) {
                String nextURI = ModelHelpers.getEndpointURI((ComponentInstance)next.getTarget());
                out.write("       <to uri=\"");
                out.write(nextURI);
                out.write("\" />");
                out.write(NL);
                continue;
            }
            componentStack.push(wireTap);
            this.coordinationContext.getCoordinator().generate(nextOne, this.coordinationContext, out);
            componentStack.pop();
        }
        out.write(NL);
    }
}

