/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.ComponentModel;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.Container;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.MEPType;
import org.eclipse.stp.eid.datamodel.Property;
import org.eclipse.stp.eid.datamodel.PropertyModel;
import org.eclipse.stp.eid.datamodel.cimero2Package;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInstanceImpl
extends EObjectImpl
implements ComponentInstance {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Connection> targetConnections;
    protected EList<Connection> sourceConnections;
    protected EList<ComponentInstanceProperty> properties;
    protected ComponentModel model;
    protected static final MEPType CURRENT_MEP_EDEFAULT = MEPType.IN_ONLY;
    protected MEPType currentMEP = CURRENT_MEP_EDEFAULT;
    protected Container container;

    protected ComponentInstanceImpl() {
    }

    protected EClass eStaticClass() {
        return cimero2Package.Literals.COMPONENT_INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<Connection> getTargetConnections() {
        if (this.targetConnections == null) {
            this.targetConnections = new EObjectWithInverseResolvingEList(Connection.class, (InternalEObject)this, 1, 0);
        }
        return this.targetConnections;
    }

    @Override
    public EList<Connection> getSourceConnections() {
        if (this.sourceConnections == null) {
            this.sourceConnections = new EObjectContainmentWithInverseEList(Connection.class, (InternalEObject)this, 2, 1);
        }
        return this.sourceConnections;
    }

    @Override
    public EList<ComponentInstanceProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new EObjectContainmentEList(ComponentInstanceProperty.class, (InternalEObject)this, 3);
        }
        return this.properties;
    }

    @Override
    public ComponentModel getModel() {
        if (this.model != null && this.model.eIsProxy()) {
            InternalEObject oldModel = (InternalEObject)this.model;
            this.model = (ComponentModel)this.eResolveProxy(oldModel);
            if (this.model != oldModel && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldModel, (Object)this.model));
            }
        }
        return this.model;
    }

    @Override
    public Graph getGraph() {
        return (Graph)this.eContainer();
    }

    public ComponentModel basicGetModel() {
        return this.model;
    }

    @Override
    public void setModel(ComponentModel newModel) {
        ComponentModel oldModel = this.model;
        this.model = newModel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldModel, (Object)this.model));
        }
    }

    @Override
    public MEPType getCurrentMEP() {
        MEPType MEPValue = MEPType.IN_ONLY;
        MEPValue = this.findTheUniqueMEPProperty() != null ? this.findTheUniqueMEPProperty() : this.getModel().getFixedMEPValue();
        this.currentMEP = MEPValue;
        return MEPValue;
    }

    @Override
    public void setCurrentMEP(MEPType newCurrentMEP) {
        MEPType oldCurrentMEP = this.currentMEP;
        MEPType mEPType = this.currentMEP = newCurrentMEP == null ? CURRENT_MEP_EDEFAULT : newCurrentMEP;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCurrentMEP, (Object)this.currentMEP));
        }
    }

    @Override
    public Container getContainer() {
        if (this.container != null && this.container.eIsProxy()) {
            InternalEObject oldContainer = (InternalEObject)this.container;
            this.container = (Container)this.eResolveProxy(oldContainer);
            if (this.container != oldContainer && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldContainer, (Object)this.container));
            }
        }
        return this.container;
    }

    public Container basicGetContainer() {
        return this.container;
    }

    public NotificationChain basicSetContainer(Container newContainer, NotificationChain msgs) {
        Container oldContainer = this.container;
        this.container = newContainer;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldContainer, (Object)newContainer);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setContainer(Container newContainer) {
        if (newContainer != this.container) {
            NotificationChain msgs = null;
            if (this.container != null) {
                msgs = ((InternalEObject)this.container).eInverseRemove((InternalEObject)this, 2, Container.class, msgs);
            }
            if (newContainer != null) {
                msgs = ((InternalEObject)newContainer).eInverseAdd((InternalEObject)this, 2, Container.class, msgs);
            }
            if ((msgs = this.basicSetContainer(newContainer, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newContainer, (Object)newContainer));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getTargetConnections()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getSourceConnections()).basicAdd((Object)otherEnd, msgs);
            }
            case 6: {
                if (this.container != null) {
                    msgs = ((InternalEObject)this.container).eInverseRemove((InternalEObject)this, 2, Container.class, msgs);
                }
                return this.basicSetContainer((Container)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getTargetConnections()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getSourceConnections()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return this.basicSetContainer(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getTargetConnections();
            }
            case 2: {
                return this.getSourceConnections();
            }
            case 3: {
                return this.getProperties();
            }
            case 4: {
                if (resolve) {
                    return this.getModel();
                }
                return this.basicGetModel();
            }
            case 5: {
                return this.getCurrentMEP();
            }
            case 6: {
                if (resolve) {
                    return this.getContainer();
                }
                return this.basicGetContainer();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.getTargetConnections().clear();
                this.getTargetConnections().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getSourceConnections().clear();
                this.getSourceConnections().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setModel((ComponentModel)newValue);
                return;
            }
            case 5: {
                this.setCurrentMEP((MEPType)((Object)newValue));
                return;
            }
            case 6: {
                this.setContainer((Container)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.getTargetConnections().clear();
                return;
            }
            case 2: {
                this.getSourceConnections().clear();
                return;
            }
            case 3: {
                this.getProperties().clear();
                return;
            }
            case 4: {
                this.setModel(null);
                return;
            }
            case 5: {
                this.setCurrentMEP(CURRENT_MEP_EDEFAULT);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.targetConnections != null && !this.targetConnections.isEmpty();
            }
            case 2: {
                return this.sourceConnections != null && !this.sourceConnections.isEmpty();
            }
            case 3: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 4: {
                return this.model != null;
            }
            case 5: {
                return this.currentMEP != CURRENT_MEP_EDEFAULT;
            }
            case 6: {
                return this.container != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", currentMEP: ");
        result.append((Object)this.currentMEP);
        result.append(')');
        return result.toString();
    }

    @Override
    public MEPType findTheUniqueMEPProperty() {
        MEPType MEPValue = null;
        int i = 0;
        while (i < this.getProperties().size() && MEPValue == null) {
            if (this.findTheUniqueMEPPropertyRec((ComponentInstanceProperty)this.getProperties().get(i)) != null) {
                MEPValue = this.findTheUniqueMEPPropertyRec((ComponentInstanceProperty)this.getProperties().get(i));
            }
            ++i;
        }
        return MEPValue;
    }

    private MEPType findTheUniqueMEPPropertyRec(ComponentInstanceProperty componentInstanceProperty) {
        MEPType MEPValue = null;
        if (componentInstanceProperty.getModel().getType().compareTo("MEP") == 0) {
            MEPValue = MEPType.get(componentInstanceProperty.getValue());
        } else if (componentInstanceProperty.getModel().getFixedMEPValue() != null) {
            MEPValue = componentInstanceProperty.getModel().getFixedMEPValue();
        } else {
            int i = 0;
            while (i < componentInstanceProperty.getSubProperties().size() && MEPValue == null) {
                if (this.findTheUniqueMEPPropertyRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i)) != null) {
                    MEPValue = this.findTheUniqueMEPPropertyRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i));
                }
                ++i;
            }
        }
        return MEPValue;
    }

    @Override
    public String getRole() {
        String componentRole = null;
        componentRole = this.getSourceConnections().size() > 0 ? "Consumer" : (this.getTargetConnections().size() > 0 ? "Provider" : "Unknown");
        return componentRole;
    }

    @Override
    public ComponentInstanceProperty getTheUniqueRoleProperty() {
        ComponentInstanceProperty componentInstanceProperty = null;
        int i = 0;
        while (i < this.getProperties().size() && componentInstanceProperty == null) {
            if (this.getTheUniqueRolePropertyRec((ComponentInstanceProperty)this.getProperties().get(i)) != null) {
                componentInstanceProperty = this.getTheUniqueRolePropertyRec((ComponentInstanceProperty)this.getProperties().get(i));
            }
            ++i;
        }
        return componentInstanceProperty;
    }

    private ComponentInstanceProperty getTheUniqueRolePropertyRec(ComponentInstanceProperty componentInstanceProperty) {
        ComponentInstanceProperty role = null;
        if (componentInstanceProperty.getModel().getType().compareTo("Role") == 0) {
            role = componentInstanceProperty;
        } else {
            int i = 0;
            while (i < componentInstanceProperty.getSubProperties().size() && role == null) {
                if (this.getTheUniqueRolePropertyRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i)) != null) {
                    role = this.getTheUniqueRolePropertyRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i));
                }
                ++i;
            }
        }
        return role;
    }

    @Override
    public ComponentInstanceProperty getComponentInstancePropertyFromPropertyModel(PropertyModel propertyModel, boolean free) {
        ComponentInstanceProperty componentInstanceProperty = null;
        int i = 0;
        while (i < this.getProperties().size() && componentInstanceProperty == null) {
            componentInstanceProperty = this.getComponentInstancePropertyFromPropertyModelRec((ComponentInstanceProperty)this.getProperties().get(i), propertyModel, free);
            ++i;
        }
        return componentInstanceProperty;
    }

    private ComponentInstanceProperty getComponentInstancePropertyFromPropertyModelRec(ComponentInstanceProperty currentProperty, PropertyModel propertyModel, boolean free) {
        ComponentInstanceProperty componentInstanceProperty = null;
        if (currentProperty.getModel().equals(propertyModel)) {
            componentInstanceProperty = free && currentProperty.getValue().compareTo("") == 0 ? currentProperty : currentProperty;
        }
        int i = 0;
        while (i < currentProperty.getSubProperties().size() && componentInstanceProperty == null) {
            componentInstanceProperty = this.getComponentInstancePropertyFromPropertyModelRec((ComponentInstanceProperty)currentProperty.getSubProperties().get(i), propertyModel, free);
            ++i;
        }
        return componentInstanceProperty;
    }

    @Override
    public void cleanUnusedProperty() {
        int i = 0;
        while (i < this.getProperties().size()) {
            this.cleanUnusedPropertyRec((ComponentInstanceProperty)this.getProperties().get(i));
            ++i;
        }
    }

    private void cleanUnusedPropertyRec(ComponentInstanceProperty componentInstanceProperty) {
        if (componentInstanceProperty.getModel().isReferenceToExternalComponent() && componentInstanceProperty.getConnection() == null) {
            componentInstanceProperty.resetValue();
            componentInstanceProperty.setConnection(null);
            ComponentInstanceProperty repeatableParent = componentInstanceProperty.getRepeatableParent();
            if (repeatableParent != null) {
                ComponentInstanceProperty repeatableParentFather = (ComponentInstanceProperty)repeatableParent.getSuperProperty();
                if (repeatableParentFather != null && repeatableParentFather.getSubProperties().size() > 1) {
                    repeatableParentFather.getSubProperties().remove((Object)repeatableParent);
                } else {
                    LoggerTool.logger.warning("Unable to delete " + repeatableParent.getName());
                }
            }
        } else {
            int i = 0;
            while (i < componentInstanceProperty.getSubProperties().size()) {
                this.cleanUnusedPropertyRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i));
                ++i;
            }
        }
    }

    @Override
    public boolean isThereAFileProperty() {
        boolean result = false;
        int i = 0;
        while (i < this.getProperties().size() && !result) {
            result = this.isThisPropertyAFileProperty((ComponentInstanceProperty)this.getProperties().get(i));
            ++i;
        }
        return result;
    }

    private boolean isThisPropertyAFileProperty(ComponentInstanceProperty componentInstanceProperty) {
        boolean result = false;
        if (componentInstanceProperty.getModel().getType().compareTo("File") == 0 && componentInstanceProperty.isValueSet()) {
            result = true;
        } else {
            int i = 0;
            while (i < componentInstanceProperty.getSubProperties().size() && !result) {
                if (((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i)).isValueSet()) {
                    result = this.isThisPropertyAFileProperty((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i));
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public void deleteProperty(ComponentInstanceProperty propertyToDelete) {
        EList<Property> subProperties = propertyToDelete.getSubProperties();
        int i = 0;
        while (i < subProperties.size()) {
            propertyToDelete.deleteSubProperty((ComponentInstanceProperty)subProperties.get(i));
            ++i;
        }
        if (propertyToDelete.getConnection() != null) {
            propertyToDelete.getConnection().getProperties().remove((Object)propertyToDelete);
        }
        this.getProperties().remove((Object)propertyToDelete);
    }

    @Override
    public List<ComponentInstanceProperty> getFreeReferencesToExternalComponents() {
        boolean gotEndpoint = false;
        boolean gotInterface = false;
        boolean gotService = false;
        List<ComponentInstanceProperty> allTargets = this.getTargetReferences();
        ArrayList<ComponentInstanceProperty> targetServices = new ArrayList<ComponentInstanceProperty>();
        for (ComponentInstanceProperty p : allTargets) {
            if (p.getConnection() != null) continue;
            if (p.getModel().getType().equals("EndPoint")) {
                if (gotEndpoint) continue;
                targetServices.add(p);
                gotEndpoint = true;
                continue;
            }
            if (p.getModel().getType().equals("Interface")) {
                if (gotInterface) continue;
                targetServices.add(p);
                gotInterface = true;
                continue;
            }
            if (!p.getModel().getType().equals("Service") || gotService) continue;
            targetServices.add(p);
            gotService = true;
        }
        return targetServices;
    }

    private List<ComponentInstanceProperty> getTargetReferences() {
        ArrayList<ComponentInstanceProperty> targetReferences = new ArrayList<ComponentInstanceProperty>();
        int i = 0;
        while (i < this.getProperties().size()) {
            this.getTargetReferenceRec((ComponentInstanceProperty)this.getProperties().get(i), targetReferences);
            ++i;
        }
        return targetReferences;
    }

    private void getTargetReferenceRec(ComponentInstanceProperty componentInstanceProperty, List<ComponentInstanceProperty> targetReferences) {
        if (componentInstanceProperty.isValidPropertyForCurrentRole()) {
            if (componentInstanceProperty.getModel().isReferenceToExternalComponent()) {
                targetReferences.add(componentInstanceProperty);
            } else {
                int i = 0;
                while (i < componentInstanceProperty.getSubProperties().size()) {
                    this.getTargetReferenceRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i), targetReferences);
                    ++i;
                }
            }
        }
    }

    @Override
    public String getReferenceValue(String type) {
        String reference = null;
        int i = 0;
        while (i < this.getProperties().size() && reference == null) {
            if (this.getReferenceRec((ComponentInstanceProperty)this.getProperties().get(i), type) != null) {
                reference = this.getReferenceRec((ComponentInstanceProperty)this.getProperties().get(i), type);
            }
            ++i;
        }
        return reference;
    }

    private String getReferenceRec(ComponentInstanceProperty componentInstanceProperty, String type) {
        String newReferenceName = null;
        if (componentInstanceProperty.isValidPropertyForCurrentRole()) {
            if (componentInstanceProperty.getModel().getType().compareTo(type) == 0) {
                if (componentInstanceProperty.isService(false) || componentInstanceProperty.isInterface(false)) {
                    String prefix = "";
                    if (((Property)componentInstanceProperty.getSubProperties().get(0)).getValue().compareTo("") != 0) {
                        prefix = String.valueOf(((Property)componentInstanceProperty.getSubProperties().get(0)).getValue()) + ":";
                    }
                    newReferenceName = String.valueOf(prefix) + ((Property)componentInstanceProperty.getSubProperties().get(1)).getValue();
                } else {
                    newReferenceName = componentInstanceProperty.getValue();
                }
            } else {
                int i = 0;
                while (i < componentInstanceProperty.getSubProperties().size() && newReferenceName == null) {
                    if (this.getReferenceRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i), type) != null) {
                        newReferenceName = this.getReferenceRec((ComponentInstanceProperty)componentInstanceProperty.getSubProperties().get(i), type);
                    }
                    ++i;
                }
            }
        }
        return newReferenceName;
    }
}

