/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.eid.ComponentRegistry;
import org.eclipse.stp.eid.IComponent;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;
import org.eclipse.stp.eid.datamodel.util.Parser;
import org.eclipse.stp.eid.runtime.RuntimeRegistry;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Cimero2EditorPlugin
extends AbstractUIPlugin
implements IStartup {
    private static final String PLUGIN_ID = "org.eclipse.stp.eid";
    private static Cimero2EditorPlugin plugin;
    private static final List<String> DEFAULTCOMPONENTMODELLIST;
    public static final String cimeroDirPath;
    public static final String cimeroComponentModelDirPath;
    public static final String cimeroIconsDirPath;
    private static RuntimeRegistry runtimeRegistry;
    private ComponentRegistry componentRegistry = new ComponentRegistry();

    static {
        DEFAULTCOMPONENTMODELLIST = new ArrayList<String>();
        cimeroDirPath = String.valueOf(System.getProperty("user.home")) + File.separator + ".cimero2";
        cimeroComponentModelDirPath = String.valueOf(System.getProperty("user.home")) + File.separator + ".cimero2" + File.separator + "componentModel";
        cimeroIconsDirPath = String.valueOf(System.getProperty("user.home")) + File.separator + ".cimero2" + File.separator + "icons";
        runtimeRegistry = new RuntimeRegistry();
    }

    public Cimero2EditorPlugin() {
        plugin = this;
    }

    public final void start(BundleContext context) throws Exception {
        super.start(context);
        runtimeRegistry.initialize();
        this.componentRegistry.initialize();
        this.createDefaultComponentModelList();
        this.loadTheComponentCache(context);
        Parser.initComponentModel();
    }

    public static RuntimeRegistry getRuntimeRegistry() {
        return runtimeRegistry;
    }

    private void loadTheComponentCache(BundleContext context) {
        File cimeroDir = new File(cimeroDirPath);
        File cimeroComponentDir = new File(cimeroDir, "componentModel");
        File cimeroIconsDir = new File(cimeroDir, "icons");
        if (cimeroComponentDir.exists() || cimeroComponentDir.mkdirs()) {
            Status stat;
            cimeroIconsDir.mkdir();
            URL componentModelURL = context.getBundle().getResource("componentModel");
            URL metaInfURL = context.getBundle().getResource("META-INF");
            for (String compDef : DEFAULTCOMPONENTMODELLIST) {
                String filen = String.valueOf(compDef) + ".xml";
                if (this.copyFileFromJar(componentModelURL, filen, cimeroComponentDir, filen, 2)) continue;
                stat = new Status(2, Cimero2EditorPlugin.getPluginId(), "Enterprise Integration Pattern component '" + compDef + "' will not be available.", null);
                this.getLog().log((IStatus)stat);
            }
            this.copyFileFromJar(componentModelURL, "component.xsd", cimeroComponentDir, "component.xsd", 4);
            this.copyFileFromJar(metaInfURL, "logging.properties", cimeroDir, "logging.properties", 2);
            Collection<IComponent> comps = ComponentRegistry.getInstance().getComponents();
            for (IComponent c : comps) {
                if (this.copyFileFromJar(c.getModelResource(), null, cimeroComponentDir, String.valueOf(c.getName()) + ".xml", 2)) continue;
                stat = new Status(2, Cimero2EditorPlugin.getPluginId(), "Enterprise Integration Pattern component '" + c.getName() + "' will not be available.", null);
                this.getLog().log((IStatus)stat);
            }
        } else {
            Status stat = new Status(4, Cimero2EditorPlugin.getPluginId(), "Unable to create " + cimeroDirPath, null);
            this.getLog().log((IStatus)stat);
        }
    }

    private void createDefaultComponentModelList() {
        DEFAULTCOMPONENTMODELLIST.add("servicemix-saxon");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-drools");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-content-based-router");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-wire-tap");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-content-enricher");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-split-aggregator");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-xpath-splitter");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-message-filter");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-pipeline");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-jsr181");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-bean");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-static-routing-slip");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-http");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-jms");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-ftp");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-quartz");
        DEFAULTCOMPONENTMODELLIST.add("servicemixmix-screen-output");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-generic-SE");
        DEFAULTCOMPONENTMODELLIST.add("servicemix-generic-BC");
        DEFAULTCOMPONENTMODELLIST.add("clockPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("csvPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("eipPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("helloworldPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("pojoPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("xsltPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("citycodePetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("soaportalPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("ftpPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("httpPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("filetransferPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("jmsPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("mailPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("soapPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("xmppPetalsComponent");
        DEFAULTCOMPONENTMODELLIST.add("xquarePetalsComponent");
    }

    public boolean copyFileFromJar(URL srcURL, String urlFile, File destDir, String fileName, int onFail) {
        try {
            URL urlc = null;
            urlc = urlFile != null ? new URL(String.valueOf(srcURL.toString()) + "/" + fileName) : srcURL;
            int buffSize = 1024;
            if (urlc != null) {
                InputStream fis = urlc.openStream();
                if (fis.available() != 0) {
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(new File(destDir, fileName));
                        byte[] buf = new byte[1024];
                        int i = 0;
                        while ((i = fis.read(buf)) != -1) {
                            fos.write(buf, 0, i);
                        }
                    }
                    finally {
                        try {
                            fis.close();
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                LoggerTool.logger.warning("Warning ! The component " + fileName + " will not be usable");
            }
            return true;
        }
        catch (Exception ex) {
            Status stat = new Status(onFail, Cimero2EditorPlugin.getPluginId(), "Cannot copy " + fileName + " to " + destDir.getAbsolutePath(), (Throwable)ex);
            this.getLog().log((IStatus)stat);
            return false;
        }
    }

    public final void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Cimero2EditorPlugin getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static String findTheFileNameInAPath(String value) {
        String[] splittedValue = value.split(Pattern.quote(File.separator));
        return splittedValue[splittedValue.length - 1];
    }
}

