/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stp.eid.coordination.ICoordinator;
import org.eclipse.stp.eid.datamodel.ESB;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.generation.IGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Runtime {
    private ESB esb;
    private String version;
    private List<ICoordinator> coordinators;
    private Map<String, String> namespaces;
    private Map<String, IGenerator> generators;

    public Runtime(String name, String ver) {
        this.version = ver;
        this.coordinators = new ArrayList<ICoordinator>();
        this.namespaces = new HashMap<String, String>();
        this.generators = new HashMap<String, IGenerator>();
        this.esb = cimero2Factory.eINSTANCE.createESB();
        this.esb.setName(name);
        cimero2Factory.eINSTANCE.getEsbList().add(this.esb);
        Namespace cimero2 = cimero2Factory.eINSTANCE.createNamespace();
        cimero2.setPrefix("cimero2");
        cimero2.setValue("http://cimero2.bull.net");
        cimero2Factory.eINSTANCE.getNamespaceList(name).add(cimero2);
    }

    public void addCoordinator(ICoordinator coord) {
        this.coordinators.add(coord);
    }

    public void addGenerator(String compoId, IGenerator geno) {
        this.generators.put(compoId, geno);
    }

    public List<ICoordinator> getCoordinators() {
        return this.coordinators;
    }

    public IGenerator getGenerator(String component) {
        return this.generators.get(component);
    }

    public void addNamespace(String pfx, String uri) {
        this.namespaces.put(pfx, uri);
        Namespace n = cimero2Factory.eINSTANCE.createNamespace();
        n.setPrefix(pfx);
        n.setValue(uri);
        cimero2Factory.eINSTANCE.getNamespaceList(this.esb.getName()).add(n);
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }
}

