/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.eid.coordination.ICoordinator;
import org.eclipse.stp.eid.generation.IGenerator;
import org.eclipse.stp.eid.runtime.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeRegistry {
    private Map<String, Map<String, Runtime>> runtimeMap = new HashMap<String, Map<String, Runtime>>();
    private static final String PLUGIN_ID = "org.eclipse.stp.eid";
    private static final String EXTENSION_EIP_RUNTIME = "eipRuntime";
    private static final String EXTENSION_EIP_COORDINATOR = "eipCoordinator";
    private static final String EXTENSION_EIP_GENERATOR = "eipGenerator";

    public Map<String, Runtime> getRuntimeVersions(String name) {
        return this.runtimeMap.get(name);
    }

    public Runtime getExactRuntimeVersion(String name, String version) {
        Map<String, Runtime> vs = this.getRuntimeVersions(name);
        if (vs != null) {
            return vs.get(version);
        }
        return null;
    }

    public ICoordinator getCoordinator(String name) {
        Map<String, Runtime> rts = this.runtimeMap.get(name);
        Runtime rt = rts.values().iterator().next();
        return rt.getCoordinators().get(0);
    }

    public void initialize() {
        this.initializeRuntimeRegistry();
        this.initializeCoordinators();
        this.initializeGenerators();
    }

    private void initializeRuntimeRegistry() {
        IExtensionRegistry extregistry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = extregistry.getConfigurationElementsFor(PLUGIN_ID, EXTENSION_EIP_RUNTIME);
        int i = 0;
        while (i < cf.length) {
            String name = cf[i].getAttribute("name");
            String version = cf[i].getAttribute("version");
            if (version == null) {
                version = "none";
            }
            Runtime r = null;
            if (!this.runtimeMap.containsKey(name)) {
                r = new Runtime(name, version);
                HashMap<String, Runtime> versionMap = new HashMap<String, Runtime>();
                versionMap.put(version, r);
                this.runtimeMap.put(name, versionMap);
            } else if (!this.runtimeMap.get(name).containsKey(version)) {
                r = new Runtime(name, version);
                this.runtimeMap.get(name).put(version, r);
            }
            IConfigurationElement[] nses = cf[i].getChildren("ns");
            int j = 0;
            while (j < nses.length) {
                r.addNamespace(nses[j].getAttribute("prefix"), nses[j].getAttribute("uri"));
                ++j;
            }
            ++i;
        }
    }

    private void initializeCoordinators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, EXTENSION_EIP_COORDINATOR);
        int i = 0;
        while (i < cf.length) {
            IConfigurationElement[] rtcf = cf[i].getChildren("runtime");
            try {
                int j = 0;
                while (j < rtcf.length) {
                    ICoordinator coord;
                    String runtimeVersion;
                    String runtimeName = rtcf[j].getAttribute("name");
                    Runtime rt = this.getExactRuntimeVersion(runtimeName, runtimeVersion = rtcf[j].getAttribute("version"));
                    if (rt != null && (coord = (ICoordinator)cf[i].createExecutableExtension("class")) instanceof ICoordinator) {
                        rt.addCoordinator(coord);
                    }
                    ++j;
                }
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void initializeGenerators() {
        IExtensionRegistry extregistry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = extregistry.getConfigurationElementsFor(PLUGIN_ID, EXTENSION_EIP_GENERATOR);
        int i = 0;
        while (i < cf.length) {
            try {
                IGenerator geno = (IGenerator)cf[i].createExecutableExtension("class");
                IConfigurationElement[] runtimes = cf[i].getChildren("runtime");
                int j = 0;
                while (j < runtimes.length) {
                    String version;
                    String name = runtimes[j].getAttribute("name");
                    Runtime rt = this.getExactRuntimeVersion(name, version = runtimes[j].getAttribute("version"));
                    if (rt != null) {
                        IConfigurationElement[] compo = runtimes[j].getChildren("component");
                        int k = 0;
                        while (k < compo.length) {
                            rt.addGenerator(compo[k].getAttribute("id"), geno);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

