/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockFlow;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockLock;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockModel;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockModelOptimiser;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockObject;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockSync;

public class LockModelScopeOptimiser
implements LockModelOptimiser {
    HashMap refCache = new HashMap();

    public void optimise(LockModel model) {
        LockObject root = model.getRoot();
        ArrayList locks = root.getDeepLockList();
        int i = 0;
        while (i < locks.size()) {
            LockLock lock = (LockLock)locks.get(i);
            lock.getParent();
            boolean hasConcurrentReferences = this.checkForConcurrentReferences(lock.getParent(), lock.getName());
            if (!hasConcurrentReferences) {
                lock.setEnabled(false, "no concurrent references");
            }
            ++i;
        }
    }

    private boolean checkForConcurrentReferences(LockObject cur, String lockName) {
        if (cur instanceof LockFlow) {
            int refCount = 0;
            if (cur.size() > 1) {
                int i = 0;
                while (i < cur.size()) {
                    if (this.checkForReference(cur.getChild(i), lockName) && ++refCount > 1) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < cur.size()) {
            LockObject tmp = cur.getChild(i);
            if (this.checkForConcurrentReferences(tmp, lockName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkForReference(LockObject cur, String lockName) {
        if (cur.hasLock(lockName)) {
            return false;
        }
        if (cur instanceof LockSync) {
            LockSync sync = (LockSync)cur;
            if (sync.getLockName().equals(lockName)) {
                return true;
            }
        } else {
            int i = 0;
            while (i < cur.size()) {
                LockObject tmp = cur.getChild(i);
                if (this.checkForReference(tmp, lockName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

