/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PathUtil {

	
	public static String getLocationFromPath(String string_path) throws IOException, CoreException {
		IPath path = new Path(string_path);
		return getLocationFromPath(path);
	}

	public static String getLocationFromPath(IPath path) throws IOException, CoreException {
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();			

		IFile file = workspaceRoot.getFile(path);

		URL url = Platform.resolve(new URL("platform:/resource"+file.getParent().getFullPath()));

//System.out.println("BASE:"+url);
		String base = url.toString();
		if (!base.endsWith("/")) {
			//need to indicate that this is a directory
			base = base+"/";
		}
		return base;
	}
	
	public static String readFileFromPath(String string_path) throws IOException, CoreException {
		IPath path = new Path(string_path);
		return readFileFromPath(path);
	}

	public static String readFileFromPath(IPath path) throws IOException, CoreException {
		IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();			

		IFile file = workspaceRoot.getFile(path);
		InputStream fin = file.getContents();
		
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		byte[] buf = new byte[1024];
		int n = 0;
		while (n != -1) {
			n = fin.read(buf,0,buf.length);
			if (n > 0) {
				bout.write(buf,0,n);
			}
		}
		
		String file_contents = new String(bout.toByteArray());
		return file_contents;
	}
	

}