/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider;

import org.eclipse.swt.widgets.Composite;

/**
 * A Property Source user interface, provides the necessary UI widgets to
 * set any required properties in a PropertySource.
 * 
 * @author amiguel
 *
 */
public interface PropertySourceUI {
	public void setPropertySource(PropertySource source);
	public int getTabCount();
	public void createTab(int tab_index, Composite parent);
	public String getTabName(int tab_index);
	public void loadFromPropertySource();
	public void saveToPropertySource();
	public void dispose();
}