/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler;

/**
 * 
 * @author amiguel
 *
 * A set of optimisation and debugging switches that affect the compilation
 * of BPEL source files into engine Programs
 */
public class Switches {

	////////////////////////////////////////////
	// STATIC SWITCHES
	//
	
	//Misc
	public static boolean CONSTANT_GARBAGE_COLLECTION = false;
	public static boolean MESSAGING_CONVERSATION_CLEANUP = false;
	
	//Debugging
	public static boolean MESSAGES_WITH_CALLSTACK = false;
	public static boolean APPEND_TRANSACTIONS_TO_CALLSTACK = false;
	
	
	////////////////////////////////////////////
	// NON-STATIC SWITCHES
	//
	
	//Misc
	public boolean HPROF_ALL_CONTROLLERS = false;
	//public String HPROF_ARGS = "cpu=samples,depth=10,";
	public String HPROF_ARGS = "cpu=times,depth=10,";

	//Optimisations
	public boolean FLOW_GRAPH_ASSET_OPTIMISATION = true;
	public boolean SINGLE_HOST_ASSET_OPTIMISATION = true;
	public boolean XPATH_EXPRESSION_CACHING = true;
	public boolean XPATH_EXPRESSION_PRECOMPUTING = true;
	public boolean MAP_XSDTYPE_TO_INDEXMAP = true;
	public boolean ASSIGN_CONSTANTS_CACHING = true;
	public boolean LOCK_RESOLVING = true;

	//Debugging aids
	public boolean APPEND_BPEL_TO_CALLSTACK = true;
	public boolean RICH_ENGINE_SERIALISATION = false;

}