/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.net.URL;
import java.net.URLClassLoader;

/**
 * 
 * @author amiguel
 * 
 * A class to define and load classes into the runtime engine Program
 * from the bytes passed around as part of a serialised Program
 */
public class ClassDefiner {
	
Definer definer;	

	public ClassDefiner(URL[] dependencies) {
		definer = new Definer(dependencies);
	}

	public ClassDefiner(URL[] dependencies, ClassLoader parent) {
		definer = new Definer(dependencies,parent);
	}
	/*
	public static Class defineSystem(byte[] b, int off, int len) throws Exception {
		ClassLoader sysload = ClassLoader.getSystemClassLoader();
		Method method = ClassLoader.class.getDeclaredMethod("defineClass",new Class[]{byte[].class,int.class,int.class});
		method.setAccessible(true);
		Class ret = (Class)method.invoke(sysload,new Object[]{b,new Integer(off),new Integer(len)});
		return ret;
	}
	
	public static Class defineSpecific(byte[] b, int off, int len, ClassLoader loader) throws Exception {
		Method method = ClassLoader.class.getDeclaredMethod("defineClass",new Class[]{byte[].class,int.class,int.class});
		method.setAccessible(true);
		Class ret = (Class)method.invoke(loader,new Object[]{b,new Integer(off),new Integer(len)});
		return ret;
	}
	*/
	
	public Class define(byte[] b, int off, int len) {
		return definer.define(b,off,len);
	} 

	//
	// private class with the singular purpose of defining classes from byte arrays
	//
	private static class Definer extends URLClassLoader {
		public Definer(URL[] deps) {
			super(deps);
		}
		public Definer(URL[] deps, ClassLoader loader) {
			super(deps, loader);
			
			for (int i = 0; i < deps.length; i++) {
				System.out.println("Program Temporary JAR Dependency: "+deps[i]);
			}
		}
		Class define(byte[] b, int off, int len) {
			return super.defineClass(null,b,off,len);	
		} 
		
		protected Class findClass(String name) throws ClassNotFoundException {
//			if (name.indexOf("Utilities") != -1) {
//				System.out.println("ASKED TO FIND "+name+" - "+super.findClass(name));
//			}
			return super.findClass(name);
		}
		protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
//			if (name.indexOf("Utilities") != -1) {
//				System.out.println("ASKED TO FIND "+name+" - "+super.loadClass(name,resolve));
//			}
			return super.loadClass(name,resolve);
		}
	}
} 