/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.publicapi.prerun.PreRunService;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

public class B2jPlatform {

	public static Class loadClassFrom(String classname, String plugin) throws Exception {
		try {
			Class c = Class.forName("org.eclipse.stp.b2j.core.publicapi.WorkbenchClassLoader");
			return (Class)c.getDeclaredMethod("loadClassFrom", new Class[]{String.class,String.class}).invoke(null, new Object[]{classname,plugin});
		} catch (Exception e) {
			return Class.forName(classname);
		}
	}
	
	public static Class loadClassFrom(String classname) throws Exception {
		try {
			Class c = Class.forName("org.eclipse.stp.b2j.core.publicapi.WorkbenchClassLoader");
			return (Class)c.getDeclaredMethod("loadClassFrom", new Class[]{String.class}).invoke(null, new Object[]{classname});
		} catch (Exception e) {
			return Class.forName(classname);
		}
	}
	
	public static void startPreRunServices() {
		DependencyInfo[] dep = getAllDependencyInfo();
		for (int i = 0; i < dep.length; i++) {
			Properties[] props = dep[i].getPreRunServices();
			for (int k = 0; k < props.length; k++) {
				try {
					PreRunService service = (PreRunService)Class.forName(props[k].getProperty("Class")).newInstance();
					service.startService();
				} catch (Exception e) {
					B2jPlugin.DBG.logVisibleError(e,"Failed to start up pre-run service: "+props[k].getProperty("Name"),false);
				}
			}
		}
	}

	
	private static ArrayList infolist = null;
	private static HashMap infos = null;

	private static Class getClass(String s) throws Exception {
		return Class.forName(s);
	}
	
	public static File getPlatformFolder() {
		//do this via reflection, if it fails, return ./
		//URL url = Platform.asLocalURL(Platform.find(B2jPlugin.getDefault().getBundle(),new Path(uri)));

		File f = new File("./");
		try {
			Class C_B2jPlugin = getClass("org.eclipse.stp.b2j.core.B2jPlugin");
			Class C_Plugin = getClass("org.eclipse.core.runtime.Plugin");
			Class C_Platform = getClass("org.eclipse.core.runtime.Platform");
			Class C_Bundle = getClass("org.osgi.framework.Bundle");
			Class C_IPath = getClass("org.eclipse.core.runtime.IPath");
			Class C_Path = getClass("org.eclipse.core.runtime.Path");

			Object plugin = C_B2jPlugin.getMethod("getDefault",new Class[0]).invoke(null,new Object[0]);
			Object bundle = C_Plugin.getMethod("getBundle",new Class[0]).invoke(plugin,new Object[0]);
			
			Object path = C_Path.getConstructor(new Class[]{String.class}).newInstance(new Object[]{"./"});
			
			Object ourl = C_Platform.getMethod("find",new Class[]{C_Bundle,C_IPath}).invoke(null,new Object[]{bundle,path});

			URL url = (URL)C_Platform.getMethod("asLocalURL",new Class[]{java.net.URL.class}).invoke(null,new Object[]{ourl});
			
			f = new File(url.getFile());
			
		} catch (Throwable e) {
		}

		f.mkdirs();
		return f;
	}
	
	public static File getDependenciesFolderFile() {
		return new File(getPlatformFolder().getAbsolutePath()+"/conf/");
	}
	public static String getDependenciesFolder() {
		return getPlatformFolder().getAbsolutePath()+"/conf/";
	}

	public static long getB2jConfigLastModified() {
		return new File(getPlatformFolder()+"/b2j.conf").lastModified();
	}
	public static B2jConfig getB2jConfig() {
		try {
			return new B2jConfig(new File(getPlatformFolder()+"/conf/Default/conf.xml"));
		} catch (Exception e) {
			return null;
		}
	}
	
	public static void rereadDependencies(File f) throws Exception {
//		System.out.println("Reading B2J Dependencies (confs) from ["+f+"]");
		
		infos = new HashMap();
		infolist = new ArrayList();
		readDependencies(f);
	}
	
	public static JARDependency[] toDependencyJARs(DependencyInfo[] info) {
		ArrayList jars = new ArrayList();
		for (int i = 0; i < info.length; i++) {
			ArrayList list = info[i].resources;
			for (int k = 0; k < list.size(); k++) {
				Properties props = (Properties)list.get(k);
				String s = props.getProperty("JAR");
				if (s != null) {
					JARDependency jdep = new JARDependency(new byte[0],s);
					jars.add(jdep);
				}
			}
		}
		JARDependency[] deps = new JARDependency[jars.size()];
		jars.toArray(deps);
		return deps;
	}
	
	public static DependencyInfo[] getEngineDependencyInfo() {
		DependencyInfo[] src = getAllDependencyInfo();
		ArrayList filtered = new ArrayList();
		for (int i = 0; i < src.length; i++) {
			if (src[i].isEngineDependant()) {
				filtered.add(src[i]);
			}
		}
		DependencyInfo[] tmp = new DependencyInfo[filtered.size()];
		filtered.toArray(tmp);
		return tmp;
	}

	public static DependencyInfo[] getPortDependencyInfo() {
		DependencyInfo[] src = getAllDependencyInfo();
		ArrayList filtered = new ArrayList();
		for (int i = 0; i < src.length; i++) {
			if (!src[i].isEngineDependant()) {
				filtered.add(src[i]);
			}
		}
		DependencyInfo[] tmp = new DependencyInfo[filtered.size()];
		filtered.toArray(tmp);
		return tmp;
	}
	
	public static DependencyInfo[] getAllDependencyInfo() {
		if (infos == null) {
			try {
				rereadDependencies(getDependenciesFolderFile());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		DependencyInfo[] tmp = new DependencyInfo[infolist.size()];
		infolist.toArray(tmp);
		return tmp;
	}
	
	public static DependencyInfo getDependencyInfo(String ID) {
		DependencyInfo[] infos = getAllDependencyInfo();
		for (int i = 0; i < infos.length; i++) {
			if (infos[i].ID.equals(ID)) {
				return infos[i];
			}
		}
		return null;
	}
	
	private static void readDependencies(File f) throws Exception {
		File[] files = f.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isDirectory()) {
				readDependencies(files[i]);
			} else if (files[i].getName().toLowerCase().equals("conf.xml")){
				readDependencyInfo(files[i]);
			}
		}
	}

	private static void readDependencyInfo(File f) throws Exception {
		DocumentBuilder builder = XMLUtil.getDocumentBuilder();
		Document doc = builder.parse(new FileInputStream(f));
		
//		System.out.println("Found conf.xml file: ["+f+"]");
		
		Element elem = doc.getDocumentElement();
		if (elem.getTagName().equals("Dependencies")) {

			String ID = Util.getTextDirectlyUnder(Util.getFirstElement(elem,"ID"));
			String Version = Util.getTextDirectlyUnder(Util.getFirstElement(elem,"Version"));
			
			DependencyInfo info = new DependencyInfo(ID,Version,f.getParentFile().getCanonicalPath()+File.separatorChar);
			
			readProperties(elem,info.resources,"Resources");
			readProperties(elem,info.wsdlbindings,"WSDLBindings");
			readProperties(elem,info.wsdlresolvers,"WSDLResolvers");
			readProperties(elem,info.portdependencies,"PortDependencies");
			readProperties(elem,info.sessiontransports,"SessionTransports");
			readProperties(elem,info.prerunservices,"PreRunServices");
			readProperties(elem,info.autojavaports,"AutoJavaPorts");
			
			DependencyInfo old = (DependencyInfo)infos.get(ID);
			
			if (old != null) {
				if (old.olderThan(info)) {
					infos.put(ID,info);
					infolist.remove(old);
					infolist.add(info);
				}
			} else {
				infos.put(ID,info);
				infolist.add(info);
			}
		} else {
//			System.out.println("Conf file is NOT a B2J conf file, document element is named ["+elem.getTagName()+"]");
		}
	}
	
	private static void readProperties(Element root, ArrayList list, String listName) {
		
		Element listRoots = Util.getFirstElement(root,listName);
		
//		System.out.println("Extension: "+listName);
		
		if (listRoots != null) {
		
			ArrayList lists = Util.getAllElements(listRoots);
			for (int k = 0; k < lists.size(); k++) {
				Element e = (Element)lists.get(k);

//				System.out.println("  "+e.getTagName());
				
				Properties props = new Properties();
				ArrayList elems = Util.getAllElements(e);
				for (int i = 0; i < elems.size(); i++) {
					Element prop = (Element)elems.get(i);
					props.put(prop.getTagName(),Util.getTextDirectlyUnder(prop));
					
//					System.out.println("    "+prop.getTagName()+" = "+Util.getTextDirectlyUnder(prop));
					
				}
				list.add(props);
			}
		} else {
//			System.out.println("  (empty)");
		}
	}
	
}