/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

public class Attr extends Node {

public Attr(Element owner, String name, String value) {
	super(owner,-1);
	this.owner = owner;
	this.name = name;
	this.value = value;	
}

String name;
String value;
Element owner;

///////////////////////////////////////
// Attribute interface
///////////////////////////////////////
public String getName() {
	return name;
} 
public Element getOwnerElement() {
	return owner;
} 
public boolean getSpecified() {
	return false;
} 
public String getValue() {
	return value;
}
public void setValue(String val) {
	this.value = val;
	owner.setAttribute(name,val);
}  

//////////////////////////////////////
// Node interface
//////////////////////////////////////

public String getNodeName() {
	return name;	
}

public String getNodeValue() {
	return value;	
}

public void setNodeValue(String value) {
	setValue(value);	
}

public short getNodeType() {
	return Node.ATTRIBUTE_NODE;	
}

public boolean hasAttributes() {
	return false;	
}

public NamedNodeMap getAttributes() {
	return null;	
}

Node cloneNode(Node parent) {
	return new Attr(owner,name,value);
}

}