/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.stp.bpmn.commands.SetBoundsCommandEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskDragHelper {
    public static final String UPDATE_CHILDREN_LOCATION_LABEL = "Update children location";
    private static final String CONTAINER_BOUNDSCOMMAND_RESIZE_LABEL = "Container resize";
    public static final String PROPERTY_CHILD_RESIZED = "childResized";

    public static void handlePropertyChangeEvent(PropertyChangeEvent event, ShapeCompartmentEditPart editPart) {
        if (PROPERTY_CHILD_RESIZED.equals(event.getPropertyName())) {
            Rectangle newContainerBounds = ((Rectangle)event.getNewValue()).getCopy();
            GraphicalEditPart container = (GraphicalEditPart)event.getSource();
            TaskDragHelper.updateContainerBounds(container, newContainerBounds, false);
        }
    }

    public static void updateContainerBounds(GraphicalEditPart editPart, Rectangle sourceBounds, boolean allowSourceRelocation) {
        IFigure source = editPart.getFigure();
        Rectangle sourceBoundsAbsolute = sourceBounds.getCopy();
        source.translateToAbsolute((Translatable)sourceBoundsAbsolute);
        GraphicalEditPart parent = (GraphicalEditPart)editPart.getParent();
        GraphicalEditPart container = (GraphicalEditPart)parent.getParent();
        Rectangle containerBounds = container.getFigure().getBounds().getCopy();
        Rectangle containerBoundsAbsolute = containerBounds.getCopy();
        container.getFigure().translateToAbsolute((Translatable)containerBoundsAbsolute);
        if (parent instanceof PoolPoolCompartmentEditPart && ((Boolean)parent.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed())).booleanValue()) {
            return;
        }
        Rectangle parentBounds = parent.getFigure().getBounds().getCopy();
        if (container instanceof PoolEditPart) {
            parentBounds.shrink(0, 5);
            parentBounds.width -= 11;
            parentBounds.x += 6;
        } else {
            parentBounds.shrink(5, 5);
        }
        Rectangle parentBoundsAbsolute = parentBounds.getCopy();
        parent.getFigure().translateToAbsolute((Translatable)parentBoundsAbsolute);
        if ((parent instanceof SubProcessSubProcessBodyCompartmentEditPart || parent instanceof PoolPoolCompartmentEditPart) && parent.getFigure().getBounds().width != 0 && parent.getFigure().getBounds().height != 0 && !parentBoundsAbsolute.contains(sourceBoundsAbsolute)) {
            Rectangle newParentBounds = parentBoundsAbsolute.getUnion(sourceBoundsAbsolute).getCopy();
            parent.getFigure().translateToRelative((Translatable)newParentBounds);
            int deltaX = newParentBounds.x - parentBounds.x;
            int deltaY = newParentBounds.y - parentBounds.y;
            int deltaWidth = newParentBounds.width - parentBounds.width;
            int deltaHeight = newParentBounds.height - parentBounds.height;
            Rectangle newContainerBounds = containerBounds.resize(deltaWidth, deltaHeight);
            newContainerBounds.translate(deltaX, deltaY);
            CompositeCommand compositeCommand = new CompositeCommand("");
            SetBoundsCommandEx containerBoundsCommand = new SetBoundsCommandEx(container.getEditingDomain(), "", container, newContainerBounds);
            if (deltaX != 0 || deltaY != 0) {
                for (Object child : parent.getChildren()) {
                    if (!allowSourceRelocation && child == editPart) continue;
                    Rectangle childBounds = ((GraphicalEditPart)child).getFigure().getBounds();
                    childBounds.translate(-deltaX, -deltaY);
                    if (childBounds.x < 0) {
                        childBounds.x = 0;
                    }
                    if (childBounds.y < 0) {
                        childBounds.y = 0;
                    }
                    SetBoundsCommand childBoundsCommand = new SetBoundsCommand(container.getEditingDomain(), "", (IAdaptable)((GraphicalEditPart)child), childBounds);
                    compositeCommand.add((IUndoableOperation)childBoundsCommand);
                }
            }
            compositeCommand.add((IUndoableOperation)containerBoundsCommand);
            try {
                compositeCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {}
        }
    }

    public static Command getNewContainerBoundsCommand(GraphicalEditPart source, List<GraphicalEditPart> selectedObjects, Rectangle selectionBounds, GraphicalEditPart container, Rectangle parentBounds, Dimension moveDelta) {
        Command command;
        Rectangle containerBounds = container.getFigure().getBounds().getCopy();
        Insets SUBPROCESS_COMPARTMENT_INSETS = new Insets(5, 5, 5, 5);
        Insets POOL_COMPARTMENT_INSETS = new Insets(5, 6, 5, 5);
        Insets containerInsets = container instanceof PoolEditPart ? POOL_COMPARTMENT_INSETS : SUBPROCESS_COMPARTMENT_INSETS;
        double zoom = 1.0;
        RootEditPart root = source.getRoot();
        if (root instanceof ScalableFreeformRootEditPart) {
            zoom = ((ScalableFreeformRootEditPart)root).getZoomManager().getZoom();
        }
        moveDelta.scale(1.0 / zoom);
        int dy = moveDelta.height;
        Dimension childrenMoveDelta = new Dimension(0, 0);
        if (selectionBounds.y + moveDelta.height < 0) {
            containerBounds.translate(0, selectionBounds.y + moveDelta.height);
            childrenMoveDelta.expand(0, -(selectionBounds.y + moveDelta.height));
            containerBounds.resize(childrenMoveDelta);
            dy = -selectionBounds.y;
        } else if (selectionBounds.y + selectionBounds.height + moveDelta.height > parentBounds.height - containerInsets.getHeight()) {
            containerBounds.resize(0, selectionBounds.y + selectionBounds.height + moveDelta.height - parentBounds.height + containerInsets.getHeight());
        }
        int dx = moveDelta.width;
        if (selectionBounds.x + moveDelta.width < 0) {
            containerBounds.translate(selectionBounds.x + moveDelta.width, 0);
            Dimension delta = new Dimension(-(selectionBounds.x + moveDelta.width), 0);
            childrenMoveDelta.expand(delta);
            containerBounds.resize(delta);
            dx = -selectionBounds.x;
        } else if (selectionBounds.x + selectionBounds.width + moveDelta.width > parentBounds.width - containerInsets.getWidth()) {
            containerBounds.resize(selectionBounds.x + selectionBounds.width + moveDelta.width - parentBounds.width + containerInsets.getWidth(), 0);
        }
        ICommand updateChildrenCommand = TaskDragHelper.getUpdateChildrenLocationCommand(source, selectedObjects, container, new Dimension(dx, dy), childrenMoveDelta);
        Dimension containerResizeDelta = containerBounds.getSize().getDifference(container.getFigure().getBounds().getSize());
        ChangeBoundsRequest setContainerBoundsRequest = new ChangeBoundsRequest((Object)"resize");
        setContainerBoundsRequest.setSizeDelta(containerResizeDelta);
        setContainerBoundsRequest.setEditParts((EditPart)container);
        Command setContainerBoundsCommand = container.getCommand((Request)setContainerBoundsRequest);
        if (updateChildrenCommand.canExecute()) {
            CompoundCommand compositeCommand = new CompoundCommand("Set container bounds and move children");
            if (setContainerBoundsCommand != null && setContainerBoundsCommand.canExecute()) {
                compositeCommand.add(setContainerBoundsCommand);
            }
            compositeCommand.add((Command)new ICommandProxy(updateChildrenCommand));
            command = compositeCommand;
        } else {
            command = setContainerBoundsCommand;
        }
        return command;
    }

    private static ICommand getUpdateChildrenLocationCommand(GraphicalEditPart source, List<GraphicalEditPart> selectedObjects, GraphicalEditPart container, Dimension allowedMoveDelta, Dimension boundsDelta) {
        CompositeCommand childLocationCommand = new CompositeCommand(UPDATE_CHILDREN_LOCATION_LABEL);
        for (Object child : source.getParent().getChildren()) {
            Rectangle childBounds = ((GraphicalEditPart)child).getFigure().getBounds().getCopy();
            if (selectedObjects.contains(child)) {
                childBounds.translate(allowedMoveDelta.width, allowedMoveDelta.height);
            } else {
                if (boundsDelta.width == 0 && boundsDelta.height == 0) continue;
                childBounds.translate(boundsDelta.width, boundsDelta.height);
            }
            ((GraphicalEditPart)child).getFigure().setBounds(childBounds);
            childLocationCommand.add((IUndoableOperation)new SetBoundsCommand(container.getEditingDomain(), UPDATE_CHILDREN_LOCATION_LABEL, (IAdaptable)((GraphicalEditPart)child), childBounds));
        }
        return childLocationCommand;
    }
}

