/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDocumentProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IFileEditorInput;

public class BpmnDocumentProvider
extends FileDiagramDocumentProvider {
    protected void saveDocumentToFile(IDocument document, IFile file, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        Diagram diagram = (Diagram)document.getContent();
        Resource diagramResource = diagram.eResource();
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        EList resources = domain.getResourceSet().getResources();
        IPath path = file.getProjectRelativePath().removeFileExtension().addFileExtension("bpmn");
        for (Resource nextResource : resources) {
            if (nextResource == diagramResource || !nextResource.isLoaded()) continue;
            try {
                if ("bpmn".equals(nextResource.getURI().fileExtension())) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    nextResource.save((OutputStream)output, Collections.EMPTY_MAP);
                    ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
                    IFile bpmnFile = file.getProject().getFile(path);
                    if (bpmnFile.exists()) {
                        bpmnFile.setContents((InputStream)input, 1, monitor);
                    } else {
                        bpmnFile.create((InputStream)input, true, monitor);
                    }
                    nextResource.setURI(URI.createPlatformResourceURI((String)bpmnFile.getFullPath().toString()));
                    continue;
                }
                nextResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                BpmnDiagramEditorPlugin.getInstance().logError("Unable to save resource: " + nextResource.getURI(), e);
            }
        }
        monitor.beginTask("Saving diagram", resources.size() + 1);
        super.saveDocumentToFile(document, file, overwrite, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    protected ISchedulingRule getSaveRule(Object element) {
        Diagram diagram;
        IDiagramDocument diagramDocument = this.getDiagramDocument(element);
        if (diagramDocument != null && (diagram = diagramDocument.getDiagram()) != null) {
            ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
            Iterator it = diagramDocument.getEditingDomain().getResourceSet().getResources().iterator();
            while (it.hasNext()) {
                IFile nextFile = WorkspaceSynchronizer.getFile((Resource)((Resource)it.next()));
                if (nextFile == null) continue;
                rules.add(this.computeSaveSchedulingRule((IResource)nextFile));
            }
            return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return super.getSaveRule(element);
    }

    protected FileDocumentProvider.FileInfo createFileInfo(IDocument document, FileDocumentProvider.FileSynchronizer synchronizer, IFileEditorInput input) {
        assert (document instanceof DiagramDocument);
        CustomModificationListener diagramListener = new CustomModificationListener(this, (DiagramDocument)document, input);
        FileDiagramDocumentProvider.DiagramFileInfo info = new FileDiagramDocumentProvider.DiagramFileInfo((FileDiagramDocumentProvider)this, document, synchronizer, (DiagramModificationListener)diagramListener);
        diagramListener.startListening();
        return info;
    }

    private ISchedulingRule computeSaveSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists() && toCreateOrModify.isSynchronized(0)) {
            return this.fResourceRuleFactory.modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists() && !parent.isSynchronized(0)) {
        }
        return this.fResourceRuleFactory.createRule(toCreateOrModify);
    }

    private class CustomModificationListener
    extends FileDiagramModificationListener {
        private DemultiplexingListener myListener;

        public CustomModificationListener(BpmnDocumentProvider documentProviderParameter, DiagramDocument documentParameter, IFileEditorInput inputParameter) {
            super((FileDocumentProvider)documentProviderParameter, documentParameter, inputParameter);
            this.myListener = null;
            final DiagramDocument document = documentParameter;
            NotificationFilter diagramResourceModifiedFilter = NotificationFilter.createEventTypeFilter((int)1);
            this.myListener = new DemultiplexingListener(diagramResourceModifiedFilter){

                protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                    Resource modifiedResource;
                    if (notification.getNotifier() instanceof EObject && (modifiedResource = ((EObject)notification.getNotifier()).eResource()) != document.getDiagram().eResource()) {
                        document.setContent(document.getContent());
                    }
                }
            };
        }

        public void startListening() {
            super.startListening();
            this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.myListener);
        }

        public void stopListening() {
            this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.myListener);
            super.stopListening();
        }
    }
}

