/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

/**
 * Date             Author              Changes
 * Jul 12, 2006     hmalphettes         Created
 **/
package org.eclipse.stp.bpmn.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

/**
 * More to come.
 * 
 * @author hmalphettes
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class SubProcessBorderFigure extends RectangleFigure {

    public static final int getFixedHeightDP(IFigure fig) {
        return MapModeUtil.getMapMode(fig).LPtoDP(32);
    }

    public static final int getFixedHeightDP(IMapMode mapmode) {
        return mapmode.LPtoDP(32);
    }

    public SubProcessBorderFigure(IMapMode mapmode) {
        Dimension dim = new Dimension(getFixedHeightDP(mapmode),
                getFixedHeightDP(mapmode));
        super.setMinimumSize(dim);
        super.setPreferredSize(dim);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width,
                getFixedHeightDP(this));
    }

    @Override
    public Dimension getMinimumSize(int wHint, int hHint) {
        return new Dimension(super.getMinimumSize(wHint, hHint).width,
                getFixedHeightDP(this));
    }

    @Override
    public void paintFigure(Graphics graphics) {
        //nothing: transparent
    }
    
    
}
