/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

/**
 *
 */
public interface IBindingDeletionDataModelProperties extends IAbstractScribblerDataModelProperties {
	/**
	 * [REQUIRED] This property is used to specify the EntryPoint or ExternalService for which to generate
	 * the Binding. 
	 * 
	 * Type = {@link org.eclipse.stp.core.sca.SCAObject} 
	 */
	public static final String SCAOBJECT = "IBindingDeletionDataModelProperties.SCAOBJECT"; 	 //$NON-NLS-1$
	
	/**
	 * [OPTIONAL] This property is used to signal which binding must be removed from the given
	 * SCAObject if only one is to be removed.
	 * 
	 * Type = {@link String}
	 */
	public static final String BINDING_TYPE = "IBindingDeletionDataModelProperties.BINDING_TYPE";  //$NON-NLS-1$
	
	/**
	 * [OPTIONAL] This property is used to signal whether all bindings are to be removed.
	 * 
	 * Type = {@link Boolean}
	 * Defalt = false
	 */
	public static final String REMOVE_ALL = "IBindingDeletionDataModelProperties.REMOVE_ALL";  //$NON-NLS-1$
}
