/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.wizards.ProjectWizardBase;
import org.eclipse.stp.sc.jaxws.wizards.WsdlGenPage;
import org.eclipse.stp.sc.jaxws.wizards.WsdlSettingPage;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.WsdlToJavaGenerateAction;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class WsdlFirstProjectWizard
extends ProjectWizardBase
implements INewWizard,
IExecutableExtension {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
    private static final String VALIDATOR_BUILDER_ID = "org.eclipse.stp.sc.annvalidator";
    private static final String WSDL_PAGE = "wsdlPage";
    private static final String GENATOR_PAGE = "genPage";
    WsdlSettingPage wsdlPage;
    WsdlGenPage wsdlGenPage;

    public WsdlFirstProjectWizard() {
        this.projectMode = "WSDLFrist";
    }

    public void addPages() {
        super.addPages();
        this.wsdlPage = new WsdlSettingPage(WSDL_PAGE);
        this.addPage((IWizardPage)this.wsdlPage);
        this.wsdlGenPage = new WsdlGenPage(GENATOR_PAGE);
        this.addPage((IWizardPage)this.wsdlGenPage);
    }

    public boolean performFinish() {
        try {
            super.performFinish();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress rwp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    WsdlFirstProjectWizard.this.generateFiles(monitor);
                }
            };
            pmd.run(false, false, rwp);
            if (this.isJaxwsProject()) {
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error during add builder", (Throwable)e);
        }
        return true;
    }

    private void generateFiles(IProgressMonitor newMonitor) {
        IProgressMonitor checkedMonitor = newMonitor != null ? newMonitor : new NullProgressMonitor();
        try {
            try {
                checkedMonitor.beginTask("Generating WSDL", 100);
                SubProgressMonitor genWSDLMonitor = new SubProgressMonitor(checkedMonitor, 40);
                genWSDLMonitor.beginTask("Generating WSDL", 10);
                this.generateWSDLFiles();
                genWSDLMonitor.worked(10);
                SubProgressMonitor genCodeMonitor = new SubProgressMonitor(checkedMonitor, 40);
                genCodeMonitor.beginTask("Generating code", 10);
                this.generateCode();
                genCodeMonitor.worked(10);
                JaxWsWorkspaceManager.setupProjectNature(this.project, "WSDLFrist");
                WorkspaceManager.addBuilder((IProject)this.project, (String)VALIDATOR_BUILDER_ID, (WorkspaceManager.BuilderOrder)WorkspaceManager.BuilderOrder.FIRST);
                checkedMonitor.worked(20);
            }
            catch (Exception e) {
                LOG.error((Object)"Error during add builder", (Throwable)e);
                checkedMonitor.done();
            }
        }
        finally {
            checkedMonitor.done();
        }
    }

    private void generateCode() {
        if (!this.wsdlPage.IsGenCode()) {
            return;
        }
        LOG.debug((Object)"try to generate code");
        WsdlToJavaGenerateAction action = new WsdlToJavaGenerateAction();
        action.setNeedMerge(false);
        Hashtable<String, Object> genParams = new Hashtable<String, Object>();
        genParams.put("TOOL_SPECIFIC_OPS", this.wsdlGenPage.paramPage.getParameters());
        String srcDir = JaxWsWorkspaceManager.getSrcFolder(this.project).getLocation().toOSString();
        LOG.debug((Object)("generate code to src dir:" + srcDir));
        genParams.put("GEN_OUTPUTDIR", srcDir);
        try {
            String wsdlUrl = this.wsdlPage.composite.rbtLocalFile.getSelection() ? this.wsdlPage.composite.txtFilePath.getText() : this.wsdlPage.composite.txtUrl.getText();
            action.generate(wsdlUrl, this.project, genParams);
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            LOG.error((Object)"error during generate code.", (Throwable)e);
        }
    }

    private void generateWSDLFiles() {
        this.createWSDLFolder();
        if (this.wsdlPage.composite.rbtLocalFile.getSelection()) {
            this.createLinkFile(this.wsdlPage.composite.txtFilePath.getText());
        } else {
            this.importRemoteFile(this.wsdlPage.composite.txtUrl.getText());
        }
        this.refreshWSDLFolder();
    }

    private void createLinkFile(String filePath) {
        if (filePath == null) {
            return;
        }
        try {
            Path location = new Path(filePath);
            String fileName = location.toFile().getName();
            IContainer wsdlFolder = JaxWsWorkspaceManager.getWSDLFolder(this.project);
            String fName = "";
            if (wsdlFolder != null) {
                fName = String.valueOf(wsdlFolder.getProjectRelativePath().toString()) + "/";
            }
            IFile linkFile = this.project.getFile(String.valueOf(fName) + fileName);
            IStatus status = this.project.getWorkspace().validateLinkLocation((IResource)linkFile, (IPath)location);
            if (status.getSeverity() == 4 || status.getSeverity() == 8) {
                LOG.error((Object)("error while creating linked file: " + filePath));
            } else {
                linkFile.createLink((IPath)location, 0, null);
                LOG.info((Object)status.getMessage());
            }
        }
        catch (CoreException e) {
            LOG.error((Object)"error while creating linked file to wsdl", (Throwable)e);
        }
    }

    private void importRemoteFile(String urlStr) {
        InputStream is = null;
        FileOutputStream fos = null;
        IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(this.project);
        try {
            try {
                IPath filePath;
                File file;
                URL url = new URL(urlStr);
                String fileName = url.getFile();
                if (!fileName.toLowerCase().endsWith(".wsdl")) {
                    fileName = new String(String.valueOf(fileName) + ".wsdl");
                }
                if ((file = (filePath = linkFolder.getLocation().append(fileName)).toFile()).exists()) {
                    file.delete();
                }
                file.createNewFile();
                fos = new FileOutputStream(file);
                URLConnection yc = url.openConnection();
                is = yc.getInputStream();
                byte[] b = new byte[5120];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    fos.write(b, 0, len);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("error while reading from the url: " + urlStr), (Throwable)e);
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {
                    LOG.error((Object)"error while closing input/output stream", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"error while closing input/output stream", (Throwable)e);
            }
        }
    }

    private void createWSDLFolder() {
        try {
            IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(this.project);
            if (!linkFolder.exists() && linkFolder instanceof IFolder) {
                ((IFolder)linkFolder).create(true, true, null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error while creating wsdl folder", (Throwable)e);
        }
    }

    private void refreshWSDLFolder() {
        try {
            IContainer linkFolder = JaxWsWorkspaceManager.getWSDLFolder(this.project);
            if (linkFolder.exists()) {
                linkFolder.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            LOG.error((Object)"error while refreshing wsdl folder", (Throwable)e);
        }
    }

    public String getWsdlURL() {
        if (this.wsdlPage.composite.rbtLocalFile.getSelection()) {
            return this.wsdlPage.composite.txtFilePath.getText();
        }
        return this.wsdlPage.composite.txtUrl.getText();
    }
}

