/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;


public class EnableScNatureAction implements IWorkbenchWindowActionDelegate {

    private static final LoggingProxy LOG = LoggingProxy.getlogger(EnableScNatureAction.class);

    private ISelection selection;

    public void dispose() {
        // TODO Auto-generated method stub
    }

    public void init(IWorkbenchWindow window) {
        // TODO Auto-generated method stub
    }

    public void run(IAction action) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }

        Iterator iter = ((IStructuredSelection)selection).iterator();

        while (iter.hasNext()) {
            Object element = iter.next();

            if (element instanceof IJavaProject) {
                try {
                    ScNature.addToProject((IJavaProject)element, ScJaxWsPropertyConstants.PROJECT_MODE_JAVAFIRST);
                } catch (CoreException ce) {
                    LOG.error("error while enabling the SC nature", ce);
                }
            }else if (element instanceof IProject) {
                try {
                    ScNature.addToProject((IProject)element, ScJaxWsPropertyConstants.PROJECT_MODE_JAVAFIRST);
                } catch (CoreException ce) {
                    LOG.error("error while enabling the SC nature", ce);
                }
            }
         }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel;
    }
}
