/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;

public class PreferencesAccessor {

    private static final IPreferenceStore PREFERENCE_STORE = ScJaxWsPlugin.getDefault().getPreferenceStore();

    public static  String resolvePrefKey(String keyPrefix, String providerExtensionId) {
        return keyPrefix + "_" + providerExtensionId;
    }

    protected static  String getPrefValue(String keyPrefix, String providerExtensionId) {
        return PREFERENCE_STORE.getString(resolvePrefKey(keyPrefix, providerExtensionId));
    }

    protected static  void setPrefValue(String keyPrefix,
                                        String providerExtensionId,
                                        String value) {
        PREFERENCE_STORE.setValue(resolvePrefKey(keyPrefix, providerExtensionId),
                                  value);
    }
    
    public static  String getKitInstallLocation(String providerExtUID) {
        return PreferencesAccessor.getPrefValue(SCPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT,
                                                providerExtUID);
    }

    public static  boolean areAnnWizardsDisplaied() {
        String prefValue = PREFERENCE_STORE.getString(SCPreferenceConstants.KEY_ANN_WIZ_ENABLED);
        return prefValue.equals(SCPreferenceConstants.VAL_ANN_WIZ_ENABLED);
    }
    
    public static boolean getSoap12Option() {
    	String pref = PREFERENCE_STORE.getString(SCPreferenceConstants.KEY_SOAP_OPTION);
    	return SCPreferenceConstants.KEY_SOAP12.equals(pref);
    }
}