/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.preferences.SCPreferenceConstants;

/**
 * This class is created to adapt FieldEditors to PropertyPages.
 * It cannot be used as a normal PreferenceStore. 
 */
public class PreferenceStoreProxy implements IPreferenceStore {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(PreferenceStoreProxy.class);
	
	private IResource target;
	
	public PreferenceStoreProxy(IResource resource) {
		target = resource;
	}

	public void addPropertyChangeListener(IPropertyChangeListener listener) {
	}

	public boolean contains(String name) {
		return false;
	}

	public void firePropertyChangeEvent(String name, Object oldValue,
			Object newValue) {
	}

	public boolean getBoolean(String name) {
		return false;
	}

	public boolean getDefaultBoolean(String name) {
		return false;
	}

	public double getDefaultDouble(String name) {
		return 0;
	}

	public float getDefaultFloat(String name) {
		return 0;
	}

	public int getDefaultInt(String name) {
		return 0;
	}

	public long getDefaultLong(String name) {
		return 0;
	}

	public String getDefaultString(String name) {
		String value = null;
		if (SCPreferenceConstants.KEY_SOAP_OPTION.equals(name)) {
			if (PreferencesAccessor.getSoap12Option()) {
				value = SCPreferenceConstants.KEY_SOAP12;
			} else {
				value = SCPreferenceConstants.KEY_SOAP11;
			}
		}
		return value;
	}

	public double getDouble(String name) {
		return 0;
	}

	public float getFloat(String name) {
		return 0;
	}

	public int getInt(String name) {
		return 0;
	}

	public long getLong(String name) {
		return 0;
	}

	public String getString(String name) {
		String value = null;
		try {
			value = target.getPersistentProperty(new QualifiedName(ScJaxWsPropertyConstants.NAME_QUALIFIER,
					name));
		} catch (CoreException e) {
			LOG.debug("error getting resource persistent property", e);
			value = SCPreferenceConstants.KEY_SOAP11;
		}
		return value;
	}

	public boolean isDefault(String name) {
		return false;
	}

	public boolean needsSaving() {
		return false;
	}

	public void putValue(String name, String value) {
	}

	public void removePropertyChangeListener(IPropertyChangeListener listener) {
	}

	public void setDefault(String name, double value) {
	}

	public void setDefault(String name, float value) {
	}

	public void setDefault(String name, int value) {
		// TODO Auto-generated method stub

	}

	public void setDefault(String name, long value) {
		// TODO Auto-generated method stub

	}

	public void setDefault(String name, String defaultObject) {
		// TODO Auto-generated method stub

	}

	public void setDefault(String name, boolean value) {
		// TODO Auto-generated method stub

	}

	public void setToDefault(String name) {
		// TODO Auto-generated method stub

	}

	public void setValue(String name, double value) {
		// TODO Auto-generated method stub

	}

	public void setValue(String name, float value) {
		// TODO Auto-generated method stub

	}

	public void setValue(String name, int value) {
		// TODO Auto-generated method stub

	}

	public void setValue(String name, long value) {
		// TODO Auto-generated method stub

	}

	public void setValue(String name, String value) {
		// TODO Auto-generated method stub

	}

	public void setValue(String name, boolean value) {
		// TODO Auto-generated method stub

	}

}
