/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.utils.ext;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.stp.sc.common.annotations.ext.IAnnotationInitializer;
import org.eclipse.stp.sc.common.utils.JDTUtils;

public class CoreAnnotationInitializer implements IAnnotationInitializer {
	
    public List<MemberValuePair> getDefaultAttributes(Class<? extends Annotation> annotationClass,
                                                      CompilationUnit astRoot,
                                                      IMember jdtMember,
                                                      SingleVariableDeclaration jdtMemberParam) {
        List<MemberValuePair> annotValues = null;
        
        if (annotationClass.equals(WebMethod.class)) {
            /*
             * @Target(value=METHOD)
             * @Retention(value=RUNTIME)
             * public @interface WebMethod
             * String action
             * boolean exclude
             * String operationName
             *
             * sample output for a method: <String sayHi()>
             * 
             * @WebMethod(action="", 
             *            operationName="sayHi",
             *            exclude=false)
             */

        	annotValues = new ArrayList<MemberValuePair>();

        	annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "operationName",
                                                        jdtMember.getElementName()));
       
            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "exclude",
                                                        false));

        } else if (annotationClass.equals(WebService.class)) {
        	/*
        	 * @Target(value=TYPE)
        	 * @Retention(value=RUNTIME)
        	 * public @interface WebService
        	 * String endpointInterface
        	 * String name
        	 * String portName
        	 * String serviceName
        	 * String targetNamespace
        	 * String wsdlLocation
        	 *
             * sample output for a class: <iona.com.helloworld.HelloWorld>
             *
             * @javax.jws.WebService(name="HelloWorld",
             *                       targetNamespace="http://helloworld.iona.com/",
             *                       wsdlLocation="")
             */

        	annotValues = new ArrayList<MemberValuePair>();

        	IType type = (IType)jdtMember;

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "name",
                                                        type.getElementName()));
            
            /*
            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "portName",
                                                        type.getElementName() + "Port"));

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "serviceName",
                                                        type.getElementName() + "Service"));
            */

            String packageName = type.getPackageFragment().getElementName();

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "targetNamespace",
                                                        JDTUtils.getNamespace(packageName.toLowerCase())));

            /*
            String fullyQualifiedName = type.getFullyQualifiedName();

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "endpointInterface",
                                                        fullyQualifiedName));
            */

        } else if (annotationClass.equals(SOAPBinding.class)) {
        	/*
        	 * @Target(value={TYPE,METHOD})
        	 * @Retention(value=RUNTIME)
        	 * public @interface SOAPBinding
        	 * SOAPBinding.ParameterStyle parameterStyle
        	 * SOAPBinding.Style style
        	 * SOAPBinding.Use use
        	 * 
        	 * sample output for a method or a class: <com.iona.helloworld.HelloWorld>
        	 * 
        	 * @SOAPBinding(parameterStyle=javax.jws.soap.SOAPBinding.ParameterStyle.WRAPPED,
        	 *              style=javax.jws.soap.SOAPBinding.Style.DOCUMENT,
        	 *              use=javax.jws.soap.SOAPBinding.Use.LITERAL)
        	 */

        	annotValues = new ArrayList<MemberValuePair>();

        	/*
        	annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "parameterStyle",
                                                        javax.jws.soap.SOAPBinding.ParameterStyle.WRAPPED));
            */

        	annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "style",
                                                        SOAPBinding.Style.RPC));

        	annotValues.add(JDTUtils.newMemberValuePair(astRoot,
        			                                    "use",
        			                                    SOAPBinding.Use.LITERAL));
        
        } else if (annotationClass.equals(WebResult.class)) {
        	/*
        	 * @Target(value=METHOD)
        	 * @Retention(value=RUNTIME)
        	 * public @interface WebResult
        	 * boolean header
        	 * String name
        	 * String partName
        	 * String targetNamespace
        	 * 
        	 * sample output for a method: <String sayHi()> of a class: <com.iona.helloworld.HelloWorld>
        	 * 
        	 * @WebResult(header=false,
        	 *            name="SayHiResult",
        	 *            partName="SayHiPart",
        	 *            targetNamespace="http://helloworld.iona.com/")
        	 */

        	annotValues = new ArrayList<MemberValuePair>();
            
            IMethod method = (IMethod)jdtMember;
            IType type = method.getDeclaringType();

            String packageName = type.getPackageFragment().getElementName();

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "targetNamespace",
                                                        JDTUtils.getNamespace(packageName)));

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "name",
                                                        "return"));

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "partName",
                                                        "return"));
        
        } else if (annotationClass.equals(WebParam.class)) {
        	/*
        	 * @Target(value=PARAMETER)
        	 * @Retention(value=RUNTIME)
        	 * public @interface WebParam
        	 * boolean header
        	 * WebParam.Mode mode
        	 * String name
        	 * String partName
        	 * String targetNamespace
        	 * 
        	 * sample output for a parameter in a method: <String sayHi(String name)> of a class: <com.iona.helloworld.HelloWorld>
        	 * 
        	 * @WebParam(header=false,
        	 *           mode=javax.jws.WebParam.Mode.IN,
        	 *           name="SayHiParamName",
        	 *           partName="SayHiParamPart",
        	 *           targetNamespace="http://helloworld.iona.com/")
        	 *           
        	 */
        	
        	annotValues = new ArrayList<MemberValuePair>();

        	IMethod method = (IMethod)jdtMember;
            IType type = method.getDeclaringType();

            String packageName = type.getPackageFragment().getElementName();

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "targetNamespace",
                                                        JDTUtils.getNamespace(packageName)));
            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                    "name",
                    jdtMemberParam.getName().getIdentifier()));
        
        } else if (annotationClass.equals(Oneway.class)) {
        	/*
        	 * @Target(value=METHOD)
        	 * @Retention(value=RUNTIME)
        	 * public @interface Oneway
        	 * 
        	 * sample output for a method: <String sayHi()>
        	 * 
        	 * @Oneway
        	 */
        
        } else if (annotationClass.equals(HandlerChain.class)) {
        	/*
        	 * @Target(value={TYPE,METHOD,FIELD})
        	 * @Retention(value=RUNTIME)
        	 * public @interface HandlerChain
        	 * String file
        	 * String name
        	 * 
        	 * sample output for a method: <String sayHi()>
        	 * 
        	 * @HandlerChain(file="",
        	 *               name="")
        	 */

        	annotValues = new ArrayList<MemberValuePair>();

            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "file",
                                                        "<specify file here>"));
            annotValues.add(JDTUtils.newMemberValuePair(astRoot,
                                                        "name",
                                                        "<specify name here>"));

        }
        return annotValues;
    }
}
