package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPostProjectProcessor;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class ProjectWizardBase extends Wizard implements INewWizard, IExecutableExtension{

	private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
	public static final String GENERAL_PAGE = "generalPage";
	protected IConfigurationElement fConfigElement;
	WizardNewProjectCreationPage genPage;
	
	protected String projectMode;
    protected IProject project;

	public ProjectWizardBase() {
		super();
        String title = ScJaxWsResources.getString("CreateWebServiceProjectWizard.Title");
        setWindowTitle(title);
	}

	public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
	    fConfigElement = cfig;
	}

	public void addPages() {
	    genPage = new WizardNewProjectCreationPage(GENERAL_PAGE);
	    genPage.setTitle(ScJaxWsResources.getString("WebServiceGeneralPage.Title"));
	    genPage.setDescription(ScJaxWsResources.getString("WebServiceGeneralPage.Description"));
	
	    ImageDescriptor banner = ScJaxWsResources.getImageDescriptor("wizban/jaxws_project_folder_wiz.jpg");
	    genPage.setImageDescriptor(banner);
	    addPage(genPage);
	}

	@Override
	public boolean performFinish() {
	    try {
	    	ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
	    	IRunnableWithProgress rwp = new IRunnableWithProgress() {
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                	createProject(monitor);
                }
	    	};
	        pmd.run(false, false, rwp);
	        
	        if(isJaxwsProject()){
	        	BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
	        }
	    } catch (InvocationTargetException e) {
	    	LOG.error(e.getMessage(), e);
	        return false;
	    } catch (InterruptedException e) {
	    	LOG.error(e.getMessage(), e);
			return false;
		}
	
	    return true;
	}
	
	protected boolean isJaxwsProject(){
		String[] natures;
		try {
			natures = this.project.getDescription().getNatureIds();
			if(natures.length > 0 
	        		&&  ScNature.NATURE_ID.equals(
	        				this.project.getDescription().getNatureIds()[0])){
	        	return true;
	        }
		} catch (CoreException e) {
			LOG.error(e.getMessage(), e);
			return false;
		}
        
        return false;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
        setNeedsProgressMonitor(true);
	}

	/**
	 * actually create the project
	 * @param newMonitor
	 * @throws InvocationTargetException
	 */
    protected boolean createProject(IProgressMonitor newMonitor) throws InvocationTargetException {
	
	    IProgressMonitor checkedMonitor = (newMonitor != null) ? newMonitor
	                                                           : new NullProgressMonitor();
	    checkedMonitor.beginTask("", 100);
	
	    IProgressMonitor createProjectMonitor = new SubProgressMonitor(checkedMonitor, 20);
	    project = JaxWsWorkspaceManager.createProject(createProjectMonitor,
	                                   genPage.getProjectName(),
	                                   genPage.getLocationPath(),
	                                   projectMode);
    
	    IPostProjectProcessor processor = ScJaxWsPlugin.getRuntimeProviderManager().getPostProjectProcessor(project);
	    if(processor != null){
	    	processor.postProcess(project);
	    }
	
	    try {
	        project.refreshLocal(IProject.DEPTH_INFINITE, checkedMonitor);
	    } catch (Exception ce) {
	    	LOG.error(ce.getMessage(), ce);
	    	ce.printStackTrace();
	    }
	    finally {
	    	checkedMonitor.done();
        }
	    return true;
	}

	public String getProjectMode() {
		return projectMode;
	}
	
	protected void setProjectMode(String value) {
		projectMode = value;
	}
}