/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.tomcat.deploydriver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.stp.sc.common.utils.FileUtils;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploySessionBase;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.deploy.tomcat.WarPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.tomcat.cp.TomcatConnection;

public class TomcatDeploySession
extends DeploySessionBase {
    private static final String CONNECTION_FACTORY_ID = "Tomcat.Container";
    private TomcatConnection mConnection;

    public TomcatDeploySession(IConnectionProfile profile) {
        super(profile);
    }

    public IStatus[] preDeployCheck(IPackageOutputDescriptor descriptor) {
        this.openConnection();
        if (this.mConnection == null || this.mConnection.getConnectException() != null) {
            Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("DeployCheck.ERROR.CannotConnectToServer", new Object[]{descriptor.getLogicalName(), this.getConnectionProfile().getName()}), this.mConnection.getConnectException());
            return new IStatus[]{status};
        }
        File deployDir = (File)this.mConnection.getRawConnection();
        if (!deployDir.exists()) {
            Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, "Deploy directory " + deployDir.getAbsolutePath() + " doesn't exists.", null);
            return new IStatus[]{status};
        }
        File deployPackage = new File(deployDir, descriptor.getLogicalName());
        if (deployPackage.exists()) {
            Status status = new Status(2, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, "Package " + descriptor.getLogicalName() + " exists on server.  Existing package will be overwritten.", null);
            return new IStatus[]{status};
        }
        return new IStatus[0];
    }

    public void deploy(IPackageOutputDescriptor descriptor) throws Exception {
        WarPackageOutputDescriptor desc = (WarPackageOutputDescriptor)descriptor;
        this.openConnection();
        File server = (File)this.mConnection.getRawConnection();
        File newPackage = new File(server, descriptor.getLogicalName());
        newPackage.createNewFile();
        AbstractInterruptibleChannel rbc = null;
        AbstractInterruptibleChannel wbc = null;
        try {
            ByteBuffer bb = ByteBuffer.allocate(8192);
            rbc = new FileInputStream(desc.getFile()).getChannel();
            wbc = new FileOutputStream(newPackage).getChannel();
            while (((FileChannel)rbc).read(bb) > 0) {
                bb.flip();
                ((FileChannel)wbc).write(bb);
                bb.clear();
            }
        }
        catch (Throwable throwable) {
            if (rbc != null) {
                try {
                    rbc.close();
                }
                catch (IOException iOException) {}
            }
            if (wbc != null) {
                try {
                    wbc.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (rbc != null) {
            try {
                rbc.close();
            }
            catch (IOException iOException) {}
        }
        if (wbc != null) {
            try {
                wbc.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void dispose() {
        if (this.mConnection != null) {
            this.mConnection.close();
            this.mConnection = null;
        }
    }

    public IVersion getServerVersion() {
        return new Version(5, 5, 0, new String());
    }

    private void openConnection() {
        if (this.mConnection == null) {
            this.mConnection = (TomcatConnection)this.getConnectionProfile().createConnection(CONNECTION_FACTORY_ID);
        }
    }

    public void undeploy(IPackageOutputDescriptor descriptor) throws Exception {
        String expandFolderName;
        File expandFolder;
        this.openConnection();
        boolean pkgDeleted = true;
        boolean FolderDeleted = true;
        File server = (File)this.mConnection.getRawConnection();
        File newPackage = new File(server, descriptor.getLogicalName());
        if (newPackage.exists()) {
            pkgDeleted = false;
            pkgDeleted = newPackage.delete();
        }
        if ((expandFolder = new File(server, expandFolderName = TomcatDeploySession.getFileNameWithoutExt(newPackage, '.'))).exists()) {
            FolderDeleted = false;
            FolderDeleted = FileUtils.deleteFile((File)expandFolder);
        }
        if (!pkgDeleted || !FolderDeleted) {
            throw new Exception("Unable to undeploy application " + expandFolderName);
        }
    }

    private static String getFileNameWithoutExt(File file, char split) {
        String fullName = file.getName();
        int i = fullName.indexOf(split);
        int leg = fullName.length();
        return i > 0 ? (i + 1 == leg ? "" : fullName.substring(0, i - 1)) : "";
    }

    public IStatus[] preUndeployCheck(IPackageOutputDescriptor descriptor) {
        return null;
    }

    public IStatus[] preUnDeployCheck(IPackageOutputDescriptor descriptor) {
        return null;
    }
}

