/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.stp.soas.deploy.core.adapters.DeployFileDeployAPIAdapterFactory;
import org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter;


/**
 * @author rcernich
 * 
 * Created on Jul 21, 2004
 */
public class Utilities extends
		org.eclipse.stp.soas.deploy.models.deployfile.util.Utilities {

	private static AdapterFactory sDeployAPIAdapterFactory = new DeployFileDeployAPIAdapterFactory();

	private static List sItemAdapterFactories = null;

	private static ComposedAdapterFactory sItemAdapterFactory = null;

	public static List getItemAdapterFactoriesList() {
		if (sItemAdapterFactories == null) {
			sItemAdapterFactories = new Vector(4);
			sItemAdapterFactories
					.addAll(org.eclipse.stp.soas.deploy.models.deployfile.util.Utilities
							.getItemAdapterFactoriesList());
			sItemAdapterFactories.add(sDeployAPIAdapterFactory);
		}
		return sItemAdapterFactories;
	}

	public static ComposedAdapterFactory getItemAdapterFactory() {
		if (sItemAdapterFactory == null) {
			sItemAdapterFactory = new ComposedAdapterFactory(
					getItemAdapterFactoriesList());
		}
		return sItemAdapterFactory;
	}

	public static IPackage adaptToIPackage(EObject object) {
		IPackage retVal;
		IDeployAPIAdapter adapter = getDeployAPIAdapter(object);
		if (adapter == null) {
			retVal = null;
		}
		else {
			retVal = adapter.asPackage();
		}
		return retVal;
	}

	public static ILogicalPackage adaptToILogicalPackage(EObject object) {
		ILogicalPackage retVal;
		IDeployAPIAdapter adapter = getDeployAPIAdapter(object);
		if (adapter == null) {
			retVal = null;
		}
		else {
			retVal = adapter.asLogicalPackage();
		}
		return retVal;
	}

	public static IConfigurablePackage adaptToIConfigurablePackage(
			EObject object) {
		IConfigurablePackage retVal;
		IDeployAPIAdapter adapter = getDeployAPIAdapter(object);
		if (adapter == null) {
			retVal = null;
		}
		else {
			retVal = adapter.asConfigurablePackage();
		}
		return retVal;
	}

	public static IPhysicalPackage adaptToIPhysicalPackage(EObject object) {
		IPhysicalPackage retVal;
		IDeployAPIAdapter adapter = getDeployAPIAdapter(object);
		if (adapter == null) {
			retVal = null;
		}
		else {
			retVal = adapter.asPhysicalPackage();
		}
		return retVal;
	}

	public static IDeployTarget adaptToIDeployTarget(EObject object) {
		IDeployTarget retVal;
		IDeployAPIAdapter adapter = getDeployAPIAdapter(object);
		if (adapter == null) {
			retVal = null;
		}
		else {
			retVal = adapter.asDeployTarget();
		}
		return retVal;
	}

	public static IConnectionProfile adaptToIConnectionProfile(EObject object) {
		IConnectionProfile retVal;
		IDeployAPIAdapter adapter = getDeployAPIAdapter(object);
		if (adapter == null) {
			retVal = null;
		}
		else {
			retVal = adapter.asConnectionProfile();
		}
		return retVal;
	}

	public static IDeployAPIAdapter getDeployAPIAdapter(EObject object) {
		IDeployAPIAdapter retVal = (IDeployAPIAdapter) EcoreUtil.getAdapter(
				object.eAdapters(), IDeployAPIAdapter.class);
		if (retVal == null) {
			EditingDomain ed = AdapterFactoryEditingDomain
					.getEditingDomainFor(object);
			if (ed == null || !(ed instanceof AdapterFactoryEditingDomain)) {
				retVal = (IDeployAPIAdapter) sDeployAPIAdapterFactory.adapt(
						object, IDeployAPIAdapter.class);
			}
			else {
				retVal = (IDeployAPIAdapter) ((AdapterFactoryEditingDomain) ed)
						.getAdapterFactory().adapt(object,
								IDeployAPIAdapter.class);
			}
		}
		return retVal;
	}
	
	
	/**
	 * Removes one folder.
	 * 
	 * @param folder
	 */
    public static void removeFolder(File folder) {
		if (folder != null && folder.isDirectory()) {
			deleteFile(folder);			
			folder = null;
		}
    }
    
    /**
     * Cascades delete all the files under one folder, and delete the folder itself.
     * 
     * @param Folder
     */
	private static void deleteFile(File Folder) {
		File[] files = Folder.listFiles();
		if (files != null && files.length > 0) {
			for (int index = 0, count = files.length; index < count; ++index) {
				deleteFile(files[index]);
			}
		}

		Folder.delete();
	}
	
	/**
	 * Creates one folder by the specified path. 
	 * 
	 * @param folder
	 * @param force
	 * @param local
	 * @throws CoreException
	 */
	public static void createFolder(IFolder folder, boolean force, boolean local)
            throws CoreException {
        String[] segments = folder.getFullPath().segments();
        IWorkspaceRoot root = folder.getWorkspace().getRoot();
        IPath projectPath = folder.getProject().getFullPath().makeAbsolute();
        IPath rootPath = root.getFullPath().makeRelative();

        IPath tempPath = rootPath;
        for (int i = 0; i < segments.length; i++) {
            tempPath = tempPath.append(segments[i]).makeAbsolute();
            if (tempPath.equals(projectPath)) {
                continue;
            }
            
            IFolder tempFolder = root.getFolder(tempPath);
            if (!tempFolder.exists()) {
            	tempFolder.create(force, local, new NullProgressMonitor());
            }
        }
    }
	
	/**
	 * Moves all the files from one source folder to one destination folder, 
	 * and keeps the files structure be the same with source folder.
	 * 
	 * @param sourceFolder
	 * @param destFolder
	 * @param fileExtension
	 * @param keepCopy
	 * @throws CoreException
	 */
	public static void moveFolder(IFolder sourceFolder, IFolder destFolder,
            String fileExtension, boolean keepCopy) throws CoreException {
        if (!sourceFolder.exists()) {
            return;
        }

        if (!destFolder.exists()) {
        	createFolder(destFolder, true, true);
        }
        
        IPath sourcePath = sourceFolder.getFullPath().makeAbsolute();
		IResource sourceMembers[] = sourceFolder.members();
		IWorkspaceRoot root = sourceFolder.getWorkspace().getRoot();

		// gets all the Files need be moved
		ArrayList movedFiles = new ArrayList();
		getMovedResources(sourceMembers, fileExtension, movedFiles);
		// moved the files
		for (Iterator iterator = movedFiles.iterator(); iterator.hasNext();) {
			IFile file = (IFile) iterator.next();
			moveFile(root, sourcePath, file, destFolder, keepCopy);
		}        
    } 
	
	/**
	 * Moves one collection of files to destination folder, keeps the file
	 * structure unchanged.
	 * 
	 * @param sourceMembers
	 * @param fileExtension
	 * @throws CoreException
	 */
	private static void getMovedResources(IResource[] sourceMembers,
			String fileExtension, ArrayList movedFiles) throws CoreException {
		for (int i = 0; i < sourceMembers.length; i++) {
			IResource resource = sourceMembers[i];

			if (resource instanceof IFile) {
				IFile tempFile = (IFile) resource;
				if ((fileExtension != null)
						&& (fileExtension.equalsIgnoreCase(tempFile
								.getFileExtension()))) {
					movedFiles.add(tempFile);
				}
			} else if (resource instanceof IFolder) {
				IResource[] members = ((IFolder) resource).members();
				getMovedResources(members, fileExtension, movedFiles);
			}
		}
    }
	
	/**
	 * Moves one file to the destination folder, keeps the file structure
	 * unchanged.
	 * 
	 * @param root
	 * @param basePath
	 * @param sourceFile
	 * @param destFolder
	 * @param keepCopy
	 * @throws CoreException
	 */
	private static void moveFile(IWorkspaceRoot root, IPath basePath,
            IFile sourceFile, IFolder destFolder, boolean keepCopy)
            throws CoreException {
	    IFolder tempFolder = destFolder;
	    IPath filePath = sourceFile.getFullPath().makeAbsolute();
	    int baseSegmentCount = basePath.segmentCount();
	    String fileName = sourceFile.getName();
	    String[] fileSegments = filePath.segments();
	    
	    for (int i = baseSegmentCount; i < (fileSegments.length - 1); i++) {
			IPath tempFolderPath = tempFolder.getFullPath().append(
					fileSegments[i]).makeAbsolute();
			tempFolder = root.getFolder(tempFolderPath);
			if (!tempFolder.exists()) {
				createFolder(tempFolder, true, true);
			}
		}
	    
	    // Makes sure the destination file be empty
	    IPath destTempPath = tempFolder.getFullPath().append(fileName).makeAbsolute();
	    IFile destTempFile = root.getFile(destTempPath);
	    if (destTempFile.exists()) {
	        destTempFile.delete(true, false, new NullProgressMonitor());
	    }
	    
	    // Copies the source file to destination folder
	    sourceFile.copy(destTempPath, true, new NullProgressMonitor());
	    	    	    
        if (!keepCopy) {
            sourceFile.delete(true, new NullProgressMonitor());
            IContainer oldContainer = sourceFile.getParent();
            while(oldContainer.members().length == 0) {        	
            	oldContainer.delete(true, new NullProgressMonitor());
            	oldContainer = oldContainer.getParent();
            }
        }
    }

}