/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.adapters.IWTPServerAdapter;
import org.eclipse.wst.server.core.IServer;

/**
 * This class is used to create server adapter from WTP server instance
 * @author jma
 */
public class ServerAdapterFactory {
	private static final LoggingProxy LOG = LoggingProxy.getlogger(ServerAdapterFactory.class);
	
	
	public static IConnectionProfile createWTPServerAdapter(IServer server, String cpProviderId,
			WtpBridgeExtension ext) 
	    throws CoreException {
		IWTPServerAdapter adapter = ext.createServerAdatper();
		adapter.setWtpServer(server);
		adapter.setProviderID(cpProviderId);
		LOG.debug("create wtp server adapter for server:"
				+ server.getId()
				+ " for cp:"
				+ cpProviderId);
		return (IConnectionProfile)adapter.asConnectionProfile();
	}
	
    
}
