/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.introspection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.Service;

public class PropertiesSharedModel {
    private static final Map madprops = new HashMap();
    public static final String SERVICE_KEY_PREFIX = "service.";
    public static final String REFERENCE_KEY_PREFIX = "reference.";
    public static final String PROPERTY_KEY_PREFIX = "property.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotifyingProperties getProperties(IFile propertiesFile) throws Exception {
        Map map = madprops;
        synchronized (map) {
            if (!madprops.containsKey(propertiesFile)) {
                NotifyingProperties props = new NotifyingProperties();
                if (!propertiesFile.exists()) {
                    propertiesFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                } else {
                    props.load(propertiesFile.getContents());
                }
                madprops.put(propertiesFile, props);
            }
            return (NotifyingProperties)madprops.get(propertiesFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Properties properties) throws Exception {
        Map map = madprops;
        synchronized (map) {
            for (Map.Entry entry : madprops.entrySet()) {
                if (entry.getValue() != properties) continue;
                IFile propertyFile = (IFile)entry.getKey();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                properties.store(outputStream, propertyFile.getFullPath().toString());
                outputStream.close();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                propertyFile.setContents((InputStream)inputStream, true, true, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(NotifyingProperties properties) {
        Map map = madprops;
        synchronized (map) {
            Iterator entries = madprops.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getValue() != properties) continue;
                entries.remove();
                break;
            }
        }
    }

    public static String serviceKey(String serviceName) {
        return SERVICE_KEY_PREFIX + serviceName;
    }

    public static void createNewService(Properties props, String serviceName, String interfaceName) {
        props.setProperty(PropertiesSharedModel.serviceKey(serviceName), interfaceName);
    }

    public static Service parseService(Properties props, String key) {
        Service service = SCAFactory.eINSTANCE.createService();
        service.setName(PropertiesSharedModel.parseServiceName(key));
        String interfaceName = props.getProperty(key);
        JavaInterface jInterface = SCAFactory.eINSTANCE.createJavaInterface();
        jInterface.setInterface(interfaceName);
        service.setInterface((Interface)jInterface);
        return service;
    }

    public static String parseServiceName(String key) {
        return key.substring(SERVICE_KEY_PREFIX.length());
    }

    public static String referenceKey(String referenceName) {
        return REFERENCE_KEY_PREFIX + referenceName;
    }

    public static void createNewReference(Properties props, String referenceName, String interfaceName) {
        props.setProperty(PropertiesSharedModel.referenceKey(referenceName), interfaceName);
    }

    public static Reference parseReference(Properties props, String key) {
        Reference reference = SCAFactory.eINSTANCE.createReference();
        reference.setName(PropertiesSharedModel.parseReferenceName(key));
        String interfaceName = props.getProperty(key);
        JavaInterface jInterface = SCAFactory.eINSTANCE.createJavaInterface();
        jInterface.setInterface(interfaceName);
        reference.setInterface((Interface)jInterface);
        return reference;
    }

    public static String parseReferenceName(String key) {
        return key.substring(REFERENCE_KEY_PREFIX.length());
    }

    public static String propertyKey(String propertyName) {
        return PROPERTY_KEY_PREFIX + propertyName;
    }

    public static void createNewProperty(Properties props, String propertyName, String defaultValue) {
        props.setProperty(PropertiesSharedModel.propertyKey(propertyName), defaultValue);
    }

    public static Property parseProperty(Properties props, String key) {
        Property property = SCAFactory.eINSTANCE.createProperty();
        property.setName(PropertiesSharedModel.parsePropertyName(key));
        property.setDefault(props.getProperty(key));
        property.setType((Object)"java.lang.String");
        property.setMany(false);
        return property;
    }

    public static String parsePropertyName(String key) {
        return key.substring(PROPERTY_KEY_PREFIX.length());
    }

    public static interface Listener {
        public void onPropertyChange(String var1, String var2);
    }

    public static class NotifyingProperties
    extends Properties {
        private static final long serialVersionUID = -1361365775349897765L;
        private final Set listeners = new HashSet();

        public synchronized Object setProperty(String key, String value) {
            Object o = super.setProperty(key, value);
            this.notifyListeners(key, value);
            return o;
        }

        public synchronized void addListener(Listener l) {
            this.listeners.add(l);
        }

        public synchronized void removeListener(Listener l) {
            this.listeners.remove(l);
        }

        private synchronized void notifyListeners(String key, String value) {
            for (Listener listener : this.listeners) {
                listener.onPropertyChange(key, value);
            }
        }
    }
}

