/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.edit.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ChangePropertyOperation
extends AbstractScribblerOperation {
    private String oldName = null;
    private String newName = null;
    private Object oldType = null;
    private Object newType = null;
    private String oldDefaultValue = null;
    private String newDefaultValue = null;
    private boolean newisMany;
    private boolean oldisMany;
    private boolean newisRequired;
    private boolean oldisRequired;

    public ChangePropertyOperation() {
    }

    public ChangePropertyOperation(IDataModel model) {
        super(model);
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ExecutionException {
        Property property = (Property)this.model.getProperty("IChangePropertyDataModelProperties.PROPERTY");
        Assert.isNotNull((Object)property);
        this.oldName = property.getName();
        this.oldType = property.getType();
        this.oldDefaultValue = property.getDefault();
        this.oldisMany = property.isMany();
        this.oldisRequired = property.isRequired();
        this.newName = this.model.getStringProperty("IChangePropertyDataModelProperties.NEW_NAME");
        this.newType = this.model.getProperty("IChangePropertyDataModelProperties.NEW_TYPE");
        this.newDefaultValue = this.model.getStringProperty("IChangePropertyDataModelProperties.NEW_DEFAULT_VALUE");
        this.newisMany = this.model.getBooleanProperty("IChangePropertyDataModelProperties.NEW_MANY");
        this.newisRequired = this.model.getBooleanProperty("IChangePropertyDataModelProperties.NEW_REQUIRED");
        if (this.newName != null && !this.newName.equals(this.oldName)) {
            property.setName(this.newName);
        }
        if (this.newType != null && !this.newType.equals(this.oldType)) {
            property.setType(this.newType);
        }
        if (this.newDefaultValue != null && !this.newDefaultValue.equals(this.oldDefaultValue)) {
            property.setDefault(this.newDefaultValue);
        }
        if (this.newisMany != this.oldisMany) {
            property.setMany(this.newisMany);
        }
        if (this.newisRequired != this.oldisRequired) {
            property.setRequired(this.newisRequired);
        }
        return OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
        Property property = (Property)this.model.getProperty("IChangePropertyDataModelProperties.PROPERTY");
        property.setName(this.newName);
        property.setType(this.newType);
        property.setDefault(this.newDefaultValue);
        property.setMany(this.newisMany);
        property.setRequired(this.newisRequired);
        return OK_STATUS;
    }

    protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
        Property property = (Property)this.model.getProperty("IChangePropertyDataModelProperties.PROPERTY");
        property.setName(this.oldName);
        property.setType(this.oldType);
        property.setDefault(this.oldDefaultValue);
        property.setMany(this.oldisMany);
        property.setRequired(this.oldisRequired);
        return OK_STATUS;
    }
}

