/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.runtimeintegrator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.stp.sc.common.runtimeintegrator.ExtGeneratorTool;
import org.eclipse.stp.sc.common.runtimeintegrator.ExtRtIntegrator;
import org.eclipse.stp.sc.common.runtimeintegrator.IGeneratorTool;
import org.eclipse.stp.sc.common.runtimeintegrator.IParameterPage;
import org.eclipse.stp.sc.common.runtimeintegrator.IRuntimeKitProcessorTemplate;
import org.eclipse.stp.sc.common.utils.ExtensionRegUtils;

public class RtIntegratorFactory {
    protected static final String EXT_CFG_GENERATORTOOL = "generatorTool";
    protected static final String EXT_ATTR_TOOLCLASS = "toolClass";
    protected static final String EXT_ATTR_PARAMETERPAGE = "parameterPage";
    protected static final String EXT_ATTR_ID = "id";
    protected static final String EXT_ATTR_TOOLTYPE = "toolType";
    protected static final String EXT_CFG_CONFIGPARAM = "configParam";
    protected static final String EXT_ATTR_PARAMNAME = "paramName";
    protected static final String EXT_ATTR_PARAMVALUE = "paramValue";
    protected static final String EXT_CFG_KITPROCESSOR = "KitProcessor";
    protected static final String EXT_ATTR_KITCLASS = "tempClass";
    protected static final String EXT_CFG_TARGETSERVER = "targetServer";
    protected static final String EXT_ATTR_SERVERTYPE = "serverType";
    protected static final String EXT_ATTR_SERVERNAME = "serverName";
    protected static final String EXT_ATTR_SERVERVERSION = "serverVersion";

    public static ExtRtIntegrator createRuntimeIntegrator(IExtension ext) throws CoreException {
        IConfigurationElement cfg;
        ExtRtIntegrator integrator = new ExtRtIntegrator();
        integrator.setId(ext.getUniqueIdentifier());
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            cfg = iConfigurationElementArray[n];
            if (cfg.getName().equals(EXT_CFG_GENERATORTOOL)) {
                ExtGeneratorTool tool = new ExtGeneratorTool();
                tool.setId(cfg.getAttribute(EXT_ATTR_ID));
                tool.setToolType(cfg.getAttribute(EXT_ATTR_TOOLTYPE));
                tool.setToolClass((IGeneratorTool)cfg.createExecutableExtension(EXT_ATTR_TOOLCLASS));
                if (cfg.getAttribute(EXT_ATTR_PARAMETERPAGE) != null) {
                    tool.setParameterPage((IParameterPage)cfg.createExecutableExtension(EXT_ATTR_PARAMETERPAGE));
                }
                IConfigurationElement[] iConfigurationElementArray2 = cfg.getChildren(EXT_CFG_CONFIGPARAM);
                int n3 = 0;
                int n4 = iConfigurationElementArray2.length;
                while (n3 < n4) {
                    IConfigurationElement paramCfg = iConfigurationElementArray2[n3];
                    tool.addConfigParam(paramCfg.getAttribute(EXT_ATTR_PARAMNAME), paramCfg.getAttribute(EXT_ATTR_PARAMVALUE));
                    ++n3;
                }
            }
            ++n;
        }
        cfg = ExtensionRegUtils.getConfigElem(ext, EXT_CFG_KITPROCESSOR, null, null);
        if (cfg != null && cfg.getAttribute(EXT_ATTR_KITCLASS) != null) {
            integrator.setKitTemplate((IRuntimeKitProcessorTemplate)cfg.createExecutableExtension(EXT_ATTR_KITCLASS));
        }
        cfg = ExtensionRegUtils.getConfigElem(ext, EXT_CFG_TARGETSERVER, null, null);
        integrator.setTargetServerName(cfg.getAttribute(EXT_ATTR_SERVERNAME));
        integrator.setTargetServerType(cfg.getAttribute(EXT_ATTR_SERVERTYPE));
        integrator.setTargetServerVersion(cfg.getAttribute(EXT_ATTR_SERVERVERSION));
        return integrator;
    }
}

