/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.stp.sc.common.wizards.AbstractScWizardPage;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSelectionPage
extends AbstractScWizardPage
implements ICheckStateListener {
    private static final int METHOD_SELECTION_PREFERRED_HEIGHT = 200;
    private static final String SELECT_ALL = "all";
    private static final String SELECT_NONE = "none";
    protected CheckboxTableViewer methodViewer;
    protected Button selectAllBtn;
    protected Button deselectAllBtn;
    HashMap<String, IMethod> mMapMethods;
    protected CreateWebMethodWizard parentWizard;

    public MethodSelectionPage(CreateWebMethodWizard aParentWizard, String pageName, String aHelpContextId) {
        super((AbstractScWizard)aParentWizard, pageName, aHelpContextId);
        this.parentWizard = aParentWizard;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Group listPanel = new Group(container, 16);
        listPanel.setLayout((Layout)new GridLayout(4, true));
        listPanel.setText(ScJaxWsResources.getString("MethodSelectionPage.AvailableMethod.Label"));
        listPanel.setLayoutData((Object)new GridData(1808));
        this.createCheckBoxList((Composite)listPanel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.selectAllBtn = new Button((Composite)listPanel, 0x1000008);
        this.selectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodSelectionPage.this.updateTable(MethodSelectionPage.SELECT_ALL);
            }
        });
        this.selectAllBtn.setText(ScJaxWsResources.getString("JaxWs.Btn.SelectAll"));
        this.selectAllBtn.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.deselectAllBtn = new Button((Composite)listPanel, 0x1000008);
        this.deselectAllBtn.setText(ScJaxWsResources.getString("JaxWs.Btn.DeselectAll"));
        this.deselectAllBtn.setLayoutData((Object)gridData);
        this.deselectAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodSelectionPage.this.updateTable(MethodSelectionPage.SELECT_NONE);
            }
        });
        this.setControl((Control)container);
    }

    public void createCheckBoxList(Composite panel) {
        this.methodViewer = CheckboxTableViewer.newCheckList((Composite)panel, (int)4);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        data.heightHint = 200;
        this.methodViewer.getTable().setLayoutData((Object)data);
        this.methodViewer.setContentProvider((IContentProvider)new MethodListContentProvider());
        this.methodViewer.setLabelProvider((IBaseLabelProvider)new MethodLabelProvider());
        this.methodViewer.setSorter(new ViewerSorter());
        this.methodViewer.setInput(new Object());
        this.methodViewer.addCheckStateListener((ICheckStateListener)this);
        this.methodViewer.getTable().setBackground(this.parentWizard.getShell().getDisplay().getSystemColor(22));
    }

    protected void updateTable(String selection) {
        if (selection.equals(SELECT_ALL)) {
            this.methodViewer.setAllChecked(true);
        } else if (selection.equals(SELECT_NONE)) {
            this.methodViewer.setAllChecked(false);
        }
        this.updatePageState();
    }

    public void applyToData(Map<String, Object> data) throws Exception {
        Object[] objects = this.methodViewer.getCheckedElements();
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        int i = 0;
        while (i < objects.length) {
            methods.add((IMethod)objects[i]);
            ++i;
        }
        data.put("DATA_KEY_SELECTED_METHODS", methods.toArray(new IMethod[0]));
    }

    public void initializeFromData(Map<String, Object> data) throws Exception {
        IMethod[] methods = (IMethod[])data.get("DATA_KEY_SELECTED_METHODS");
        if (methods == null || methods.length == 0) {
            this.updateTable(SELECT_ALL);
        } else {
            this.updateTable(SELECT_NONE);
            int i = 0;
            while (i < methods.length) {
                String signature = this.getMethodSignature(methods[i]);
                if (this.mMapMethods.containsKey(signature)) {
                    this.methodViewer.setChecked((Object)methods[i], true);
                }
                ++i;
            }
            this.updatePageState();
        }
    }

    protected boolean validateInputs() {
        Object[] methods;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.methodViewer != null && (methods = this.methodViewer.getCheckedElements()).length < 1) {
            this.setErrorMessage(ScJaxWsResources.getString("MethodSelectionPage.MissingMethod.Error"));
            return false;
        }
        return true;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updatePageState();
    }

    public Button getSelectAllBtn() {
        return this.selectAllBtn;
    }

    private String getMethodSignature(IMethod method) {
        try {
            return Signature.toString((String)method.getSignature(), (String)method.getElementName(), null, (boolean)false, (boolean)false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IMethod[] getFileMethods() {
        this.mMapMethods = new HashMap();
        try {
            IJavaElement[] children = this.parentWizard.getJavaMemberFromData().getCompilationUnit().findPrimaryType().getChildren();
            int i = 0;
            while (i < children.length) {
                String methodSignature;
                IMethod method;
                int flags;
                if (!(children[i].getElementType() != 9 || Flags.isPrivate((int)(flags = (method = (IMethod)children[i]).getFlags())) || Flags.isProtected((int)flags) || this.mMapMethods.containsKey(methodSignature = this.getMethodSignature(method)))) {
                    this.mMapMethods.put(methodSignature, method);
                }
                ++i;
            }
            return this.mMapMethods.values().toArray(new IMethod[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    class MethodLabelProvider
    extends LabelProvider {
        MethodLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null || !(element instanceof IMethod)) {
                return null;
            }
            return MethodSelectionPage.this.getMethodSignature((IMethod)element);
        }
    }

    public class MethodListContentProvider
    implements IStructuredContentProvider {
        private Object[] items;

        public MethodListContentProvider() {
            this.items = MethodSelectionPage.this.getFileMethods();
        }

        public Object[] getElements(Object inputElement) {
            return this.items;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

