/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.IDeploySession;
import org.eclipse.stp.soas.deploy.core.IDeploySessionFactory;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructor;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageValidator;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.ISupportValidator;
import org.eclipse.stp.soas.deploy.core.ISupportedServerType;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.internal.deploy.core.DeployTarget;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.SupportedServerType;
import org.eclipse.stp.soas.internal.deploy.core.SupportedTechnologyType;

public class DeployDriverExtension
implements IDeployDriverExtension {
    public static final String ATTR_ID = "id";
    public static final String ATTR_PROFILE = "profile";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_TRANSACTIONAL = "isTransactional";
    public static final String ELEM_SERVER = "supportedServer";
    public static final String ELEM_PACKAGE_CONSTRUCTOR = "packageConstructor";
    public static final String ELEM_SUPPORTED_TECHNOLOGY = "supportedTechnology";
    public static final String ATTR_SUPPORT_VALIDATOR = "supportValidator";
    public static final String ATTR_PACKAGE_VALIDATOR = "packageValidator";
    private String mID;
    private String mName;
    private String mProfile;
    private boolean mTransactional;
    private IDeploySessionFactory mFactory;
    private ISupportedServerType mSupportedServer;
    private Map mIdToPackageConstructor;
    private IConfigurationElement mElement;

    public DeployDriverExtension(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
    }

    public IDeploySession createDeploySession(IConnectionProfile profile) {
        try {
            this.initFactory();
            return this.mFactory.createDeploySession(profile);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IConnectionProfileProvider getConnectionProfileProvider() {
        return ConnectionProfileManager.getInstance().getProvider(this.mProfile);
    }

    public String getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isTransaction() {
        return this.mTransactional;
    }

    public IDeployTarget adaptProfile(IConnectionProfile profile) {
        DeployTarget idt = profile.getProviderId().equals(this.getConnectionProfileProvider().getId()) ? new DeployTarget(this, profile) : null;
        return idt;
    }

    public ISupportedServerType getSupportedServerType() {
        return this.mSupportedServer;
    }

    public boolean supportsServer(IServerType type) {
        return this.mSupportedServer.supportsServer(type);
    }

    public List getPackageConstructors() {
        return new ArrayList(this.mIdToPackageConstructor.values());
    }

    public IPackageConstructorExtension getPackageConstructor(ITechnologyType type) {
        IPackageConstructorExtension retVal = null;
        Iterator it = this.mIdToPackageConstructor.values().iterator();
        while (retVal == null && it.hasNext()) {
            IPackageConstructorExtension tmp = (IPackageConstructorExtension)it.next();
            if (!tmp.getSupportedTechnologyType().supportsTechnology(type)) continue;
            retVal = tmp;
        }
        return retVal;
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        Assert.isTrue((boolean)"deployDriver".equals(element.getName()));
        this.mElement = element;
        this.mID = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mProfile = element.getAttribute(ATTR_PROFILE);
        this.mTransactional = Boolean.valueOf(element.getAttribute(ATTR_TRANSACTIONAL));
        if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.out.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.processingDeployDriver", new Object[]{this.mID}));
            System.out.flush();
        }
        if (this.getConnectionProfileProvider() == null) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.profileNotSpecified", new Object[]{this.mID, this.mProfile}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.profileNotSpecified"));
        }
        IConfigurationElement[] supportedServers = element.getChildren(ELEM_SERVER);
        if (supportedServers.length < 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.supportedServerNotSpecified", new Object[]{this.mID}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.supportedServerNotSpecified"));
        }
        if (supportedServers.length > 1) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.multipleSupportedServerElements", new Object[]{this.mID}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.multipleSupportedServerElements"));
        }
        this.processServer(supportedServers[0]);
        this.processPackageConstructors(element.getChildren(ELEM_PACKAGE_CONSTRUCTOR));
    }

    private void processServer(IConfigurationElement element) throws PackageExtensionException {
        this.mSupportedServer = new SupportedServerType(element);
    }

    private void processPackageConstructors(IConfigurationElement[] elements) throws PackageExtensionException {
        this.mIdToPackageConstructor = new TreeMap();
        int index = 0;
        int count = elements.length;
        while (index < count) {
            this.processPackageConstructor(elements[index]);
            ++index;
        }
    }

    private void processPackageConstructor(IConfigurationElement element) throws PackageExtensionException {
        PackageConstructorExtension ipce = new PackageConstructorExtension(element);
        if (this.mIdToPackageConstructor.containsKey(ipce.getID())) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.duplicatePackageConstructor", new Object[]{this.mID, ipce.getID()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.duplicatePackageConstructor"));
        }
        this.mIdToPackageConstructor.put(ipce.getID(), ipce);
    }

    private void initFactory() throws CoreException {
        if (this.mFactory == null) {
            this.mFactory = (IDeploySessionFactory)this.mElement.createExecutableExtension(ATTR_CLASS);
        }
    }

    public class PackageConstructorExtension
    implements IPackageConstructorExtension {
        private IConfigurationElement mElement;
        private String mID;
        private IPackageConstructor mConstructor;
        private ISupportValidator mSupportValidator;
        private IPackageValidator mPackageValidator;
        private ISupportedTechnologyType mSupportedTechnology;

        public PackageConstructorExtension(IConfigurationElement element) throws PackageExtensionException {
            this.init(element);
        }

        public IConfigurationElement getConfigurationElement() {
            return this.mElement;
        }

        public String getID() {
            return this.mID;
        }

        public IPackageOutputDescriptor createPackage(ILogicalPackage pkg, IPackageCreationContext context, IPackageConfiguration configuration) throws CoreException {
            this.initConstructor();
            if (this.mConstructor == null) {
                Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.error.couldNotLoadPackageConstructor"), null);
                throw new CoreException((IStatus)status);
            }
            IPackageOutputDescriptor retVal = this.mConstructor.createPackage(pkg, context, configuration);
            return retVal;
        }

        public boolean supportsPackage(ILogicalPackage pkg) {
            boolean retVal = this.getSupportedTechnologyType().supportsTechnology(pkg.getTechnologyType());
            if (retVal) {
                this.initSupportValidator();
                if (this.mSupportValidator != null) {
                    retVal = retVal && this.mSupportValidator.supportsFile(pkg.getFile());
                }
            }
            return retVal;
        }

        public IStatus[] validatePackage(ILogicalPackage pkg, IPackageConfiguration configuration, IDeployTarget target) {
            this.initPackageValidator();
            IStatus[] retVal = this.mPackageValidator == null ? new IStatus[]{} : this.mPackageValidator.validate(pkg, configuration, target);
            return retVal;
        }

        public ISupportedTechnologyType getSupportedTechnologyType() {
            return this.mSupportedTechnology;
        }

        public IDeployDriverExtension getDeployDriver() {
            return DeployDriverExtension.this;
        }

        private void init(IConfigurationElement element) throws PackageExtensionException {
            this.mElement = element;
            this.mID = element.getAttribute(DeployDriverExtension.ATTR_ID);
            IConfigurationElement[] supportedTechnologies = element.getChildren(DeployDriverExtension.ELEM_SUPPORTED_TECHNOLOGY);
            if (supportedTechnologies.length < 1) {
                if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                    System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.supportedTechnologyNotSpecified", new Object[]{this.getDeployDriver().getID(), this.mID}));
                    System.err.flush();
                }
                throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.supportedTechnologyNotSpecified"));
            }
            if (supportedTechnologies.length > 1) {
                if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                    System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.multipleSupportedTechnologyElements", new Object[]{this.getDeployDriver().getID(), this.mID}));
                    System.err.flush();
                }
                throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.exception.multipleSupportedTechnologyElements"));
            }
            this.processTechnology(supportedTechnologies[0]);
        }

        private void processTechnology(IConfigurationElement technology) throws PackageExtensionException {
            this.mSupportedTechnology = new SupportedTechnologyType(technology);
        }

        private void initConstructor() {
            block3: {
                if (this.mConstructor == null) {
                    try {
                        this.mConstructor = (IPackageConstructor)this.mElement.createExecutableExtension(DeployDriverExtension.ATTR_CLASS);
                    }
                    catch (CoreException coreException) {
                        if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block3;
                        System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.couldNotLoadPackageConstructor", new Object[]{this.getDeployDriver().getID(), this.getID(), this.mElement.getAttribute(DeployDriverExtension.ATTR_CLASS)}));
                        System.err.flush();
                    }
                }
            }
        }

        private void initSupportValidator() {
            block3: {
                if (this.mSupportValidator == null) {
                    try {
                        this.mSupportValidator = (ISupportValidator)this.mElement.createExecutableExtension(DeployDriverExtension.ATTR_SUPPORT_VALIDATOR);
                    }
                    catch (CoreException coreException) {
                        if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block3;
                        System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.couldNotLoadSupportValidator", new Object[]{this.getDeployDriver().getID(), this.getID(), this.mElement.getAttribute(DeployDriverExtension.ATTR_SUPPORT_VALIDATOR)}));
                        System.err.flush();
                    }
                }
            }
        }

        private void initPackageValidator() {
            block3: {
                if (this.mPackageValidator == null) {
                    try {
                        this.mPackageValidator = (IPackageValidator)this.mElement.createExecutableExtension(DeployDriverExtension.ATTR_PACKAGE_VALIDATOR);
                    }
                    catch (CoreException coreException) {
                        if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block3;
                        System.err.println(DeployCorePlugin.getDefault().getResourceString("DeployDriverExtension.trace.error.couldNotLoadPackageValidator", new Object[]{this.getDeployDriver().getID(), this.getID(), this.mElement.getAttribute(DeployDriverExtension.ATTR_SUPPORT_VALIDATOR)}));
                        System.err.flush();
                    }
                }
            }
        }
    }
}

