/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.soas.deploy.core.DefaultSupportValidator;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackageExtension;
import org.eclipse.stp.soas.deploy.core.ISupportValidator;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;

public abstract class PackageExtension
implements IPackageExtension {
    public static final String ATTR_ID = "id";
    public static final String ATTR_FILE_EXTENSION = "fileExtension";
    public static final String ATTR_SUPPORT_VALIDATOR = "supportValidator";
    private String mID;
    private String mFileExt;
    private ISupportValidator mVerifier;
    private IConfigurationElement mElement;

    public PackageExtension(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
    }

    public String getID() {
        return this.mID;
    }

    public String getFileExtension() {
        return this.mFileExt;
    }

    public boolean supportsFile(IFile file) {
        block3: {
            if (this.mVerifier == null) {
                try {
                    this.mVerifier = (ISupportValidator)this.mElement.createExecutableExtension(ATTR_SUPPORT_VALIDATOR);
                }
                catch (CoreException coreException) {
                    this.mVerifier = new DefaultSupportValidator(this.mFileExt);
                    if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block3;
                    System.out.println(DeployCorePlugin.getDefault().getResourceString("PackageExtension.trace.warning.usingDefaultSupportValidator", new Object[]{this.mID}));
                    System.out.flush();
                }
            }
        }
        return this.mVerifier.supportsFile(file);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.mElement;
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.out.println(DeployCorePlugin.getDefault().getResourceString("PackageExtension.trace.processingPackageExtension", new Object[]{element.getName(), element.getAttribute(ATTR_ID)}));
            System.out.flush();
        }
        this.mElement = element;
        this.processAttributes();
    }

    private void processAttributes() throws PackageExtensionException {
        this.mID = this.mElement.getAttribute(ATTR_ID);
        this.mFileExt = this.mElement.getAttribute(ATTR_FILE_EXTENSION);
        if (this.mID == null) {
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("PackageExtension.exception.idNotSpecified"));
        }
        if (this.mFileExt == null) {
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("PackageExtension.exception.fileExtensionNotSpecified"));
        }
    }
}

