/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.internal.deploy.util.DeployUtilPlugin;
import org.eclipse.swt.widgets.Composite;

public class WizardNewFileCreationPage
extends org.eclipse.ui.dialogs.WizardNewFileCreationPage
implements ISummaryDataSource {
    private IWorkspace mWorkspace = DeployUtilPlugin.getWorkspace();
    private IContainer mSelectedContainer = null;
    private IFile mSelectedFile = null;
    private String smFileExtension;

    public WizardNewFileCreationPage(String pageName) {
        super(pageName, (IStructuredSelection)StructuredSelection.EMPTY);
    }

    public WizardNewFileCreationPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, (IStructuredSelection)StructuredSelection.EMPTY);
        this.setTitle(title);
        this.setImageDescriptor(titleImage);
    }

    public void init(String fileExtension, ISelection selection) {
        Object o;
        this.smFileExtension = fileExtension;
        if (!selection.isEmpty() && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            IResource res = (IResource)o;
            if (res.getType() == 2 || res.getType() == 4) {
                this.mSelectedContainer = (IContainer)res;
            } else if (res.getType() == 1) {
                this.mSelectedContainer = res.getParent();
                if (res instanceof IFile) {
                    this.mSelectedFile = (IFile)res;
                }
            }
        }
    }

    public String getFullFileName() {
        String fileName = this.getFileName();
        if (this.smFileExtension != null && !fileName.endsWith(String.valueOf('.') + this.smFileExtension)) {
            fileName = String.valueOf(fileName) + '.' + this.smFileExtension;
        }
        return fileName;
    }

    public IFile getOutputFile() {
        IContainer container = (IContainer)this.mWorkspace.getRoot().findMember(this.getContainerFullPath());
        return this.mWorkspace.getRoot().getFile(container.getFullPath().append(this.getFullFileName()));
    }

    public boolean canFlipToNextPage() {
        Object container;
        IPath absoluteContainerPath;
        File systemFile;
        String fileName = this.getFullFileName();
        IPath localContainerPath = this.getContainerFullPath();
        if (localContainerPath != null && (systemFile = new File((absoluteContainerPath = (container = localContainerPath.segmentCount() == 1 ? this.mWorkspace.getRoot().getProject(localContainerPath.lastSegment()) : this.mWorkspace.getRoot().getFolder(this.getContainerFullPath())).getLocation()).toOSString(), fileName)).exists()) {
            this.setErrorMessage(DeployUtilPlugin.getDefault().getResourceString("WizardNewFileCreationPage.ERROR.FileExists", new Object[]{container.getFullPath().append(fileName)}));
            return false;
        }
        return super.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.mSelectedContainer != null) {
            this.setContainerFullPath(this.mSelectedContainer.getFullPath());
        }
        if (this.mSelectedFile != null) {
            int idx = this.mSelectedFile.getName().lastIndexOf(46);
            if (idx == -1) {
                this.setFileName(this.mSelectedFile.getName());
            } else {
                this.setFileName(this.mSelectedFile.getName().substring(0, idx));
            }
        }
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>(1);
        summaryData.add(new String[]{DeployUtilPlugin.getDefault().getResourceString("WizardNewFileCreationPage.summary.fileName"), this.getOutputFile().getFullPath().toString()});
        return summaryData;
    }
}

