/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.deploy.tomcat.cp;

import java.util.Properties;

import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.stp.soas.deploy.tomcat.DeployTomcatResources;

public class TomcatConnectionProfileNewWizard extends NewConnectionProfileWizard {

	TomcatDirWizardPage dirPage;
	private final String pageName = "Dir";
	
	
	public TomcatConnectionProfileNewWizard() {
		setWindowTitle(DeployTomcatResources.getString(
				"new.wizardpage.title")); //$NON-NLS-1$
		setDefaultPageImageDescriptor(SharedImages.DESC_WIZBAN);
	}
	
	public void addPages() {
		mProfilePage = new TomcatNewCPWizardPage();
		addPage(mProfilePage);

		addCustomPages();

		mSummaryPage = new SummaryWizardPage(this);
		addPage(mSummaryPage);
	}
	
	@Override
	public void addCustomPages() {
        dirPage = new TomcatDirWizardPage(pageName);
        addPage(dirPage);
	}

	@Override
	public Properties getProfileProperties() {
		Properties props = new Properties();
		props.put(IConnectionConstants.PROFILEPPROPERTY_DIR, dirPage.getTomcatDir()); 
		return props;
	}

}
