/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.ConversationMember;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.ConversationWait;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.CriticalThreadGroup;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.DataMap;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.NonCriticalThreadGroup;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.RunnerWait;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.Semaphore;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.TransactionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.Variable;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.api.SoapDaemonConnector;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTMessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionClient;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionServer;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageReader;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageUtils;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.message.TransactionListener;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FileUtil;
import org.eclipse.stp.b2j.core.jengine.internal.utils.GCThread;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.LineBasedPrintStream;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.misc.internal.HexData;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class Controller
extends Thread
implements TransactionListener {
    public static final String DEPS_CACHE_DIR = "depscache";
    public static final long CACHE_LIMIT_MEGS = 100L;
    public static final String[] CONTROLLER_SOCKET_IDS = new String[]{"Controller:server->client transaction", "Controller:server<-client transaction", "Controller:server<->client notifications"};
    public static final int CONTROLLER_UNRECOGNISED_MESSAGE = -1;
    public static final int CONTROLLER_EMPTY = -2;
    public static final int CONTROLLER_INTERNAL_ERROR = -3;
    public static final int MASK_PRIORITY = 0xF00000;
    public static final int MASK_UNKNOWN_PRIORITY = 0;
    public static final int MASK_LOW_PRIORITY = 0x100000;
    public static final int MASK_MEDIUM_PRIORITY = 0x200000;
    public static final int MASK_HIGH_PRIORITY = 0x400000;
    public static final int MASK_OTHER = 0xF000000;
    public static final int MASK_PIGGYBACK = 0x1000000;
    public static final int CONTROLLER_LAUNCH_PROGRAM = 0x10000A;
    public static final int CONTROLLER_LAUNCH_PROGRAM_OK = 11;
    public static final int CONTROLLER_LAUNCH_PROGRAM_FAIL = 12;
    public static final int CONTROLLER_SET_PROGRAM = 1048676;
    public static final int CONTROLLER_SET_PROGRAM_OK = 101;
    public static final int CONTROLLER_SET_PROGRAM_FAIL = 102;
    public static final int CONTROLLER_LAUNCH_RUNNER = 2097352;
    public static final int CONTROLLER_LAUNCH_RUNNER_OK = 201;
    public static final int CONTROLLER_LAUNCH_RUNNER_FAIL = 202;
    public static final int CONTROLLER_MAKE_VARIABLE = 1048876;
    public static final int CONTROLLER_MAKE_VARIABLE_OK = 301;
    public static final int CONTROLLER_MAKE_VARIABLE_FAIL = 302;
    public static final int CONTROLLER_MAKE_VARIABLE_EXISTS = 303;
    public static final int CONTROLLER_MAKE_SEMAPHORE = 0x100190;
    public static final int CONTROLLER_MAKE_SEMAPHORE_OK = 401;
    public static final int CONTROLLER_MAKE_SEMAPHORE_FAIL = 402;
    public static final int CONTROLLER_MAKE_SEMAPHORE_EXISTS = 403;
    public static final int CONTROLLER_WAIT_SEMAPHORE = 4194804;
    public static final int CONTROLLER_WAIT_SEMAPHORE_OK = 501;
    public static final int CONTROLLER_WAIT_SEMAPHORE_FAIL = 502;
    public static final int CONTROLLER_WAIT_SEMAPHORE_WILL_NOTIFY = 503;
    public static final int CONTROLLER_SIGNAL_SEMAPHORE = 4194904;
    public static final int CONTROLLER_SIGNAL_SEMAPHORE_OK = 601;
    public static final int CONTROLLER_SIGNAL_SEMAPHORE_FAIL = 602;
    public static final int CONTROLLER_STORE_VARIABLE = 4195004;
    public static final int CONTROLLER_STORE_VARIABLE_OK = 701;
    public static final int CONTROLLER_STORE_VARIABLE_FAIL = 702;
    public static final int CONTROLLER_FETCH_VARIABLE = 4195104;
    public static final int CONTROLLER_FETCH_VARIABLE_OK = 801;
    public static final int CONTROLLER_FETCH_VARIABLE_FAIL = 802;
    public static final int CONTROLLER_GET_VARIABLE = 2098052;
    public static final int CONTROLLER_GET_VARIABLE_OK = 901;
    public static final int CONTROLLER_GET_VARIABLE_FAIL = 902;
    public static final int CONTROLLER_GET_SEMAPHORE = 2098152;
    public static final int CONTROLLER_GET_SEMAPHORE_OK = 1001;
    public static final int CONTROLLER_GET_SEMAPHORE_FAIL = 1002;
    public static final int CONTROLLER_MAKE_DIRTY_VARIABLE = 1049676;
    public static final int CONTROLLER_TRACE = 1200;
    public static final int CONTROLLER_SYNC_CLOCK = 1300;
    public static final int CONTROLLER_SYNC_CLOCK_OK = 1301;
    public static final int CONTROLLER_SYNC_CLOCK_FAIL = 1302;
    public static final int CONTROLLER_PRINT = 1400;
    public static final int CONTROLLER_MAKE_HASHMAP = 1050076;
    public static final int CONTROLLER_MAKE_HASHMAP_OK = 1501;
    public static final int CONTROLLER_MAKE_HASHMAP_FAIL = 1502;
    public static final int CONTROLLER_MAKE_HASHMAP_EXISTS = 1503;
    public static final int CONTROLLER_GET_HASHMAP = 2098752;
    public static final int CONTROLLER_GET_HASHMAP_OK = 1601;
    public static final int CONTROLLER_GET_HASHMAP_FAIL = 1602;
    public static final int CONTROLLER_PUT_HASHMAP = 4196004;
    public static final int CONTROLLER_PUT_HASHMAP_OK = 1701;
    public static final int CONTROLLER_PUT_HASHMAP_FAIL = 1702;
    public static final int CONTROLLER_RETRIEVE_HASHMAP = 4196104;
    public static final int CONTROLLER_RETRIEVE_HASHMAP_OK = 1801;
    public static final int CONTROLLER_RETRIEVE_HASHMAP_FAIL = 1802;
    public static final int CONTROLLER_RETRIEVE_HASHMAP_NULL = 1803;
    public static final int CONTROLLER_CLEAR_HASHMAP = 4196504;
    public static final int CONTROLLER_CLEAR_HASHMAP_OK = 2201;
    public static final int CONTROLLER_CLEAR_HASHMAP_FAIL = 2202;
    public static final int CONTROLLER_GET_HOSTS = 1050876;
    public static final int CONTROLLER_GET_HOSTS_OK = 2301;
    public static final int CONTROLLER_GET_HOSTS_FAIL = 2302;
    public static final int CONTROLLER_GET_VARIABLE_LIST = 1050976;
    public static final int CONTROLLER_GET_VARIABLE_LIST_OK = 2401;
    public static final int CONTROLLER_GET_VARIABLE_LIST_FAIL = 2402;
    public static final int CONTROLLER_RUNNER_DEATH = 2500;
    public static final int CONTROLLER_RUNNER_JOIN = 4196904;
    public static final int CONTROLLER_RUNNER_JOIN_OK = 2601;
    public static final int CONTROLLER_RUNNER_JOIN_WILL_NOTIFY = 2602;
    public static final int CONTROLLER_RUNNER_JOIN_FAIL = 2603;
    public static final int CONTROLLER_ABORT = 2700;
    public static final int CONTROLLER_MESSAGE_CONSUME = 4197104;
    public static final int CONTROLLER_MESSAGE_CONSUME_OK = 2801;
    public static final int CONTROLLER_MESSAGE_CONSUME_WILL_NOTIFY = 2802;
    public static final int CONTROLLER_MESSAGE_CONSUME_FAIL = 2803;
    public static final int CONTROLLER_MESSAGE_PUBLISH = 4197204;
    public static final int CONTROLLER_MESSAGE_PUBLISH_OK = 2901;
    public static final int CONTROLLER_MESSAGE_PUBLISH_FAIL = 2902;
    public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE = 4197304;
    public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE_OK = 3001;
    public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE_WILL_NOTIFY = 3002;
    public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE_FAIL = 3003;
    public static final int CONTROLLER_RUNNER_STACKDUMP = 3100;
    public static final int CONTROLLER_DEBUG = 3200;
    public static final int CONTROLLER_SET_LOG_LEVEL = 1051876;
    public static final int CONTROLLER_SET_LOG_LEVEL_OK = 3301;
    public static final int CONTROLLER_SET_LOG_LEVEL_FAIL = 3302;
    public static final int CONTROLLER_RETRIEVE_HASHMAP_KEYLIST = 4197704;
    public static final int CONTROLLER_RETRIEVE_HASHMAP_KEYLIST_OK = 3401;
    public static final int CONTROLLER_RETRIEVE_HASHMAP_KEYLIST_FAIL = 3402;
    public static final int CONTROLLER_RUNNER_STACKTRACE = 3500;
    public static final int CONTROLLER_SET_HEADLESS = 0x100E10;
    public static final int CONTROLLER_SET_HEADLESS_OK = 3601;
    public static final int CONTROLLER_SET_HEADLESS_FAIL = 3602;
    public static final int CONTROLLER_CHECK_DEPS_CACHE = 1052276;
    public static final int CONTROLLER_CHECK_DEPS_CACHE_OK = 3701;
    public static final int CONTROLLER_CHECK_DEPS_CACHE_FAIL = 3702;
    boolean PRINT_INFO = true;
    boolean PRINT_DEBUG = true;
    private static final int CLIENT_CONTROLLER = 0;
    private static final Object LOCK_SERVER = new Object();
    long clock = 0L;
    int id;
    Session session;
    Program program;
    byte[] programb;
    Message jar_dependencies;
    private static final Object LOCK_CLIENTS = new Object();
    ArrayList clients_client = new ArrayList();
    ArrayList clients_server = new ArrayList();
    ArrayList clients_nout = new ArrayList();
    ArrayList clients_nin = new ArrayList();
    HashMap hosts_map;
    ArrayList subcontrollers_hosts = new ArrayList();
    ArrayList subcontrollers_client = new ArrayList();
    ArrayList subcontrollers_server = new ArrayList();
    ArrayList subcontrollers_nout = new ArrayList();
    ArrayList subcontrollers_nin = new ArrayList();
    UnqueuedMutex shared_vars_MUTEX = new UnqueuedMutex();
    ArrayList shared_vars = new ArrayList();
    HashMap shared_vars_map = new HashMap();
    Object shared_sems_LOCK = new Object();
    ArrayList shared_sems = new ArrayList();
    HashMap shared_sems_map = new HashMap();
    Object shared_hashmaps_LOCK = new Object();
    ArrayList shared_hashmaps = new ArrayList();
    HashMap shared_hashmaps_map = new HashMap();
    CriticalThreadGroup clienttg = new CriticalThreadGroup();
    CriticalThreadGroup ctg = new CriticalThreadGroup();
    NonCriticalThreadGroup nctg = new NonCriticalThreadGroup();
    Object runner_directory_LOCK = new Object();
    HashMap runner_directory = new HashMap();
    Object conversation_directory_LOCK = new Object();
    HashMap conversation_directory = new HashMap();
    SessionAddress actual_address;
    String client_host;
    Message subcontroller_dependencies;
    String base_jar_path;
    private static boolean redirected = false;

    private static void redirectStdout() {
        redirected = true;
        System.setOut(System.err);
    }

    private static void restoreStdout() {
        Controller.restoreStdout(null);
    }

    private static void restoreStdout(String s) {
        if (redirected) {
            redirected = false;
            PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128));
            pout.println(s);
            System.setOut(pout);
        }
    }

    public static void main(String[] args) {
        String classpath;
        Message dependencies;
        SessionAddress address;
        int id;
        Controller.redirectStdout();
        if (Switches.CONSTANT_GARBAGE_COLLECTION) {
            GCThread.startThread();
        }
        if (args.length < 1) {
            Controller.restoreStdout();
            System.out.println("Too few arguments");
            return;
        }
        try {
            id = Integer.parseInt(args[0]);
        }
        catch (Throwable throwable) {
            Controller.restoreStdout();
            System.out.println("Invalid id");
            return;
        }
        BufferedReader bread = new BufferedReader(new InputStreamReader(System.in));
        try {
            String req_address = HexData.hexStringToString(bread.readLine().trim());
            address = SessionAddress.fromString(req_address);
        }
        catch (Throwable throwable) {
            Controller.restoreStdout();
            System.out.println("Invalid session address");
            return;
        }
        try {
            byte[] req_deps = HexData.hexStringToByteArray(bread.readLine().trim());
            dependencies = MessageUtils.bytesToMessage(req_deps);
        }
        catch (Throwable throwable) {
            Controller.restoreStdout();
            System.out.println("Invalid depedencies message");
            return;
        }
        try {
            classpath = bread.readLine().trim();
        }
        catch (Throwable throwable) {
            Controller.restoreStdout();
            System.out.println("Invalid depedencies message");
            return;
        }
        try {
            new Controller(address, id, dependencies, classpath);
        }
        catch (Throwable e) {
            Controller.restoreStdout();
            System.out.println("Controller create failed: " + Logger.getOneLineStackTrace(e));
            e.printStackTrace();
        }
    }

    public Controller(SessionAddress session_address, int id, Message subc_deps, String classpath) throws Exception {
        this.id = id;
        this.subcontroller_dependencies = subc_deps;
        this.base_jar_path = classpath;
        try {
            this.session = SessionFactory.newSession(session_address, false);
            this.session.beginNonBlocking();
            this.session.waitUntilSessionTransportBound();
            this.actual_address = this.session.getActualAddress();
            Controller.restoreStdout(HexData.stringToHexString(SessionAddress.toString(this.actual_address)));
            System.out.flush();
            this.start();
        }
        catch (IOException iOException) {
            throw new Exception("No free ports!");
        }
        System.gc();
    }

    public SessionAddress getAddress() {
        return this.actual_address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread th = Thread.currentThread();
        th.setName("JEngine Controller [Daemon Server Init] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
        try {
            this.session.waitUntilSessionTransportReady();
            this.client_host = this.session.getActualAddress().getInitiatorHost();
            Logger.direct("new Controller (version " + Version.getVersionAsString() + ") on " + this.session.getActualAddress());
            short c_client = 0;
            short c_server = 1;
            short c_notify = 2;
            MultiplexerInputStream mxin = new MultiplexerInputStream(this.session.getInputStream((short)0));
            MultiplexerOutputStream mxout = new MultiplexerOutputStream(this.session.getOutputStream((short)0));
            MTTransactionClient cclient = TransactionFactory.getTransactionClient(mxin.getInputStream(c_client), mxout.getOutputStream(c_client), this.clienttg, "JEngine Controller [Client Client] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
            MTTransactionServer cserver = TransactionFactory.getTransactionServer(mxin.getInputStream(c_server), mxout.getOutputStream(c_server), this, this.clienttg, "JEngine Controller [Client Server] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
            MessageReader creader = new MessageReader(mxin.getInputStream(c_notify), this.clienttg, "JEngine Controller [Client Notify Server] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
            MTMessageWriter cwriter = new MTMessageWriter(mxout.getOutputStream(c_notify));
            cwriter.write(new Message(this.subcontrollers_client.size()));
            Object object = LOCK_CLIENTS;
            synchronized (object) {
                this.clients_client.add(cclient);
                this.clients_server.add(cserver);
                this.clients_nout.add(cwriter);
                this.clients_nin.add(creader);
            }
            this.subcontrollers_client.add(cclient);
            this.subcontrollers_server.add(cserver);
            this.subcontrollers_nout.add(cwriter);
            this.subcontrollers_nin.add(creader);
            Reader cthread = new Reader(creader, new NonCriticalThreadGroup(), "JEngine Controller [Client Notify Server] Thread (ID: " + this.id + ") (" + this.actual_address + ")");
            cthread.start();
        }
        catch (Throwable t) {
            Logger.error("controller reader thread died", t);
        }
    }

    private void setHeadless(boolean headless) throws Exception {
        this.clienttg.setExitOnException(!headless);
    }

    private void setLogLevel(boolean error, boolean warning, boolean info) throws Exception {
        Logger.PRINT_ERROR = error;
        Logger.PRINT_WARNING = warning;
        Logger.PRINT_INFO = info;
        int i = 0;
        while (i < this.subcontrollers_client.size()) {
            MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(i);
            Message m = new Message(1000);
            if (error) {
                m.append(1);
            } else {
                m.append(0);
            }
            if (warning) {
                m.append(1);
            } else {
                m.append(0);
            }
            if (info) {
                m.append(1);
            } else {
                m.append(0);
            }
            m = tc.doTransaction(m);
            if (m.getType() != 1001) {
                throw new Exception("SubController set log level failed " + m);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String s) {
        if (!this.PRINT_INFO) {
            return;
        }
        Message m = new Message(1400);
        m.append(s);
        Object object = LOCK_CLIENTS;
        synchronized (object) {
            int i = 0;
            while (i < this.clients_nout.size()) {
                try {
                    MTMessageWriter cwriter = (MTMessageWriter)this.clients_nout.get(i);
                    cwriter.write(m);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
    }

    public static Message checkDependenciesCache(Message check) {
        Message ret = new Message(check.getType());
        File f = new File(DEPS_CACHE_DIR);
        if (!f.exists()) {
            f.mkdirs();
        }
        long tnow = System.currentTimeMillis();
        File[] allFiles = f.listFiles();
        int i = 0;
        while (i < check.length()) {
            String s = (String)check.get(i);
            boolean cached = false;
            int k = 0;
            while (k < allFiles.length) {
                if (s.equals(allFiles[k].getName())) {
                    cached = true;
                    allFiles[k].setLastModified(System.currentTimeMillis());
                }
                ++k;
            }
            if (!cached) {
                ret.append((String)null);
            } else {
                ret.append(s);
            }
            ++i;
        }
        long tot = 0L;
        int i2 = 0;
        while (i2 < allFiles.length) {
            tot += allFiles[i2].length();
            ++i2;
        }
        if (tot > 102400000L) {
            Arrays.sort(allFiles, new FileAgeComparator());
            i2 = 0;
            while (i2 < allFiles.length) {
                if (allFiles[i2].lastModified() < tnow) {
                    tot -= allFiles[i2].length();
                    allFiles[i2].delete();
                }
                if (tot < 102400000L) break;
                ++i2;
            }
        }
        return ret;
    }

    public static void storeNewJarsToCache(Message dependencies) throws Exception {
        File f = new File(DEPS_CACHE_DIR);
        if (!f.exists()) {
            f.mkdirs();
        }
        int i = 0;
        while (i < dependencies.length()) {
            if (dependencies.getType(i) == 4) {
                JARDependency dep = JARDependency.fromMessage((Message)dependencies.get(i));
                String cachekey = dep.getCacheKey();
                File temp = new File("depscache/temp." + System.currentTimeMillis() + "." + cachekey + ".temp");
                File dest = new File("depscache/" + cachekey);
                FileOutputStream fout = new FileOutputStream(temp);
                fout.write(dep.getJarData());
                fout.close();
                temp.renameTo(dest);
            }
            ++i;
        }
    }

    private void setProgram(byte[] programb, Message dependencies) throws Exception {
        this.programb = programb;
        this.jar_dependencies = dependencies;
        Controller.storeNewJarsToCache(dependencies);
        this.program = Program.readProgram(programb);
        if (this.program.getPrintStdouterr()) {
            Logger.direct("Redirecting stdout to engine messaging");
            System.setOut(new PrintStream(new LineBasedPrintStream(){

                public void doSomethingWith(String s) {
                    try {
                        Controller.this.print(s);
                    }
                    catch (Exception exception) {
                        Logger.warning(s);
                    }
                }
            }));
            System.setErr(new PrintStream(new LineBasedPrintStream(){

                public void doSomethingWith(String s) {
                    try {
                        Controller.this.print(s);
                    }
                    catch (Exception exception) {
                        Logger.warning(s);
                    }
                }
            }));
        }
        this.PRINT_INFO = this.program.getPrintInfo();
        this.PRINT_DEBUG = this.program.getPrintDebug();
        ArrayList addresses = this.program.getAddresses();
        ArrayList daemonaddresses = this.program.getDaemonAddresses();
        addresses.add(0, new SessionAddress("CLIENT_MACHINE", 0, 0, "CLIENT_MACHINE", 0, 0));
        daemonaddresses.add(0, new SessionAddress("CLIENT_MACHINE", 0, 0, "CLIENT_MACHINE", 0, 0));
        int cid = 0;
        if (addresses.size() < 1) {
            throw new IOException("no hosts specified");
        }
        this.hosts_map = new HashMap();
        int i = 1;
        while (i < addresses.size()) {
            SessionAddress address = (SessionAddress)addresses.get(i);
            SessionAddress daemonaddress = (SessionAddress)daemonaddresses.get(i);
            this.subcontrollers_hosts.add(address.getListenerHost());
            this.hosts_map.put(address.getListenerHost(), new Integer(++cid));
            Logger.info("CONTROLLER: Creating SubController at " + address);
            SoapDaemonConnector daemon_connector = new SoapDaemonConnector((SessionAddress)daemonaddress.clone());
            if (!daemon_connector.supportsVersion(Version.getVersion())) {
                this.traceDebug("Updating daemon on " + address.getListenerHost() + " (this may take a while)");
                FileInputStream fin = new FileInputStream(this.base_jar_path);
                daemon_connector.addVersion(Version.getVersion(), FileUtil.readFileBinary(fin));
                fin.close();
            }
            JARDependency[] subcontroller_deps = new JARDependency[this.subcontroller_dependencies.length()];
            int k = 0;
            while (k < subcontroller_deps.length) {
                subcontroller_deps[k] = JARDependency.fromMessage((Message)this.subcontroller_dependencies.get(k));
                ++k;
            }
            SessionAddress subcontroller_address = daemon_connector.newSubController(cid, subcontroller_deps, address);
            Logger.info("CONTROLLER: Created OK, connecting to SubController");
            Session subcontroller_session = SessionFactory.newSession(subcontroller_address, true);
            subcontroller_session.begin();
            short client = 0;
            short server = 1;
            short notifications = 2;
            MultiplexerInputStream mxin = new MultiplexerInputStream(subcontroller_session.getInputStream((short)0));
            MultiplexerOutputStream mxout = new MultiplexerOutputStream(subcontroller_session.getOutputStream((short)0));
            MTTransactionClient tc = TransactionFactory.getTransactionClient(mxin.getInputStream(client), mxout.getOutputStream(client), this.ctg, "JEngine Controller [SubController Client Reader] Thread (ID: " + this.id + ") (" + subcontroller_address + ")");
            MTTransactionServer ts = TransactionFactory.getTransactionServer(mxin.getInputStream(server), mxout.getOutputStream(server), this, this.ctg, "JEngine Controller [SubController Server] Thread (ID: " + this.id + ") (" + subcontroller_address + ")");
            MessageWriter nout = new MessageWriter(mxout.getOutputStream(notifications));
            MessageReader nin = new MessageReader(mxin.getInputStream(notifications), this.ctg, "JEngine Controller [SubController Notify Reader] Thread (ID: " + this.id + ") (" + subcontroller_address + ")");
            Reader scthread = new Reader(nin, this.ctg, "JEngine Controller [SubController Notify Reader] Thread (ID: " + this.id + ") (" + subcontroller_address + ")");
            scthread.start();
            this.subcontrollers_client.add(tc);
            this.subcontrollers_server.add(ts);
            this.subcontrollers_nout.add(nout);
            this.subcontrollers_nin.add(nin);
            ++i;
        }
        i = 1;
        while (i < this.subcontrollers_client.size()) {
            MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(i);
            Logger.info("CONTROLLER: Setting client host (" + this.client_host + ") on SubController");
            Message m = new Message(900);
            m.append(this.client_host);
            m = tc.doTransaction(m);
            if (m.getType() != 901) {
                throw new IOException("SubController set client host failed " + m);
            }
            m = new Message(1200);
            int k = 0;
            while (k < dependencies.length()) {
                if (dependencies.getType(k) == 4) {
                    JARDependency dep = JARDependency.fromMessage((Message)dependencies.get(k));
                    m.append(dep.getCacheKey());
                } else {
                    m.append((String)dependencies.get(k));
                }
                ++k;
            }
            if ((m = tc.doTransaction(m)).getType() != 1201) {
                throw new IOException("SubController check dependencies cache failed " + m);
            }
            Message sub_dependencies = new Message();
            int k2 = 0;
            while (k2 < m.length()) {
                String key = (String)m.get(k2);
                if (key == null) {
                    if (this.jar_dependencies.getType(k2) == 4) {
                        sub_dependencies.append((Message)this.jar_dependencies.get(k2));
                    } else {
                        String path = "depscache/" + key;
                        FileInputStream fin = new FileInputStream(path);
                        byte[] dat = StreamUtils.readAll(fin);
                        fin.close();
                        JARDependency jd = new JARDependency(dat, path);
                        sub_dependencies.append(JARDependency.toMessage(jd));
                    }
                } else {
                    sub_dependencies.append(key);
                }
                ++k2;
            }
            Logger.info("CONTROLLER: Sending program to SubController");
            m = new Message(100);
            m.append(programb);
            m.append(sub_dependencies);
            m = tc.doTransaction(m);
            int type = m.getType();
            if (type != 101) {
                throw new IOException("SubController set program failed " + m);
            }
            ++i;
        }
    }

    private void launchProgram() throws IOException {
        MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(1);
        Message m = new Message(10);
        m.append(1);
        m.append("engine_main");
        m = tc.doTransaction(m);
        if (m.getType() != 11) {
            throw new IOException("Error launching program " + m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message launchRunner(int host, Integer count, String method, Message args) throws IOException {
        MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(host);
        Message m = new Message(10);
        m.append(count);
        m.append(method);
        m.append(args);
        m = tc.doTransaction(m);
        if (m.getType() != 11) {
            throw new IOException("Error launching program " + m);
        }
        Message ids = (Message)m.get(0);
        Object object = this.runner_directory_LOCK;
        synchronized (object) {
            int i = 0;
            while (i < ids.length()) {
                Long id = (Long)ids.get(i);
                if (this.runner_directory.get(id) == null) {
                    this.runner_directory.put(id, new RunnerWait());
                } else {
                    RunnerWait rwait = (RunnerWait)this.runner_directory.remove(id);
                    if (rwait.waiting_runner != -1L) {
                        this.wakeRunner(rwait.waiting_runner);
                    }
                }
                ++i;
            }
        }
        return ids;
    }

    void signalRunner(long rid) throws IOException {
        int c_index = ID.CONTROLLER_INDEX(rid);
        MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(c_index);
        Message m = new Message(200);
        m.append(rid);
        m = tc.doTransaction(m);
        if (m.getType() != 201) {
            throw new IOException("Error signalling runner " + m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message doTransactionHighPriority(Message m, int type) throws Throwable {
        Message r;
        block159: {
            if (type == 4195104) {
                Logger.info("CONTROLLER: Fetch Variable " + m);
                Integer hid = (Integer)m.get(0);
                Integer vid = (Integer)m.get(1);
                Integer vtypeo = (Integer)m.get(2);
                int vtype = vtypeo;
                Variable v = null;
                this.shared_vars_MUTEX.lock();
                try {
                    v = (Variable)this.shared_vars.get(vid - 1);
                    this.shared_vars_MUTEX.release();
                }
                catch (Throwable e) {
                    this.shared_vars_MUTEX.release();
                    throw e;
                }
                Object e = v.LOCK;
                synchronized (e) {
                    block158: {
                        try {
                            if (vtype != v.getType()) {
                                r = new Message(802);
                                break block158;
                            }
                            try {
                                r = new Message(801);
                                r.append(vtype);
                                Object newval = v.getValue();
                                if (newval == null) {
                                    throw new NullPointerException("variable value is null");
                                }
                                switch (vtype) {
                                    case 0: {
                                        r.append((Integer)newval);
                                        break;
                                    }
                                    case 4: {
                                        r.append((String)newval);
                                        break;
                                    }
                                    case 5: {
                                        r.append((byte[])newval);
                                        break;
                                    }
                                    case 6: {
                                        r.append((Message)newval);
                                        break;
                                    }
                                    case 1: {
                                        r.append((Long)newval);
                                        break;
                                    }
                                    case 3: {
                                        r.append((Double)newval);
                                        break;
                                    }
                                    case 2: {
                                        r.append(new Double(((Float)newval).doubleValue()));
                                        break;
                                    }
                                    default: {
                                        throw new ClassCastException("No recognised type");
                                    }
                                }
                                if (v.getDirtyType()) {
                                    boolean[] hosts = v.getDirtyHosts();
                                    hosts[hid.intValue()] = false;
                                }
                            }
                            catch (ClassCastException e2) {
                                r = new Message(802);
                                r.append(Logger.getStackTrace(e2));
                            }
                        }
                        catch (NullPointerException e3) {
                            r = new Message(802);
                            r.append(Logger.getStackTrace(e3));
                        }
                    }
                }
            }
            if (type == 4197304) {
                Logger.info("CONTROLLER: Send And Receive Message " + m);
                String conversation = (String)m.get(0);
                Message msgdata = (Message)m.get(1);
                Long waiter_id = (Long)m.get(2);
                Message conversationReturns = (Message)m.get(3);
                Message extras = new Message();
                long wakeup_id = 0L;
                Message wakeup_data = null;
                Object object = this.conversation_directory_LOCK;
                synchronized (object) {
                    ConversationWait rwait = (ConversationWait)this.conversation_directory.get(conversation);
                    if (rwait == null) {
                        rwait = new ConversationWait();
                        this.conversation_directory.put(conversation, rwait);
                    }
                    if (rwait.waiting_runners.isEmpty()) {
                        rwait.available_messages.addLast(msgdata);
                    } else {
                        Long waiting_runner;
                        ConversationMember member = (ConversationMember)rwait.waiting_runners.getFirst();
                        if (member.conversations.length() > 1) {
                            msgdata.append(conversation);
                        }
                        if (ID.CONTROLLER_ID(waiting_runner = member.id) == ID.CONTROLLER_ID(waiter_id)) {
                            extras = new Message(700);
                            extras.append((long)waiting_runner);
                            extras.append(msgdata);
                        } else {
                            wakeup_id = waiting_runner;
                            wakeup_data = msgdata;
                        }
                        ArrayList obsolete_conversations = member.conversation_waits;
                        int i = 0;
                        while (i < obsolete_conversations.size()) {
                            ConversationWait cwait = (ConversationWait)obsolete_conversations.get(i);
                            cwait.waiting_runners.remove(member);
                            ++i;
                        }
                        if (Switches.MESSAGING_CONVERSATION_CLEANUP && rwait.available_messages.isEmpty() && rwait.waiting_runners.isEmpty()) {
                            this.conversation_directory.remove(conversation);
                        }
                    }
                }
                if (wakeup_data != null) {
                    try {
                        this.notifyMessageConsumer(wakeup_id, wakeup_data);
                    }
                    catch (Exception e) {
                        Logger.error("Error notifying message consumer in sendAndReceive ", e);
                    }
                }
                Object e = this.conversation_directory_LOCK;
                synchronized (e) {
                    ConversationWait rwaitReturn;
                    boolean mustWait = true;
                    r = null;
                    int i = 0;
                    while (i < conversationReturns.length()) {
                        String conversationReturn = (String)conversationReturns.get(i);
                        rwaitReturn = (ConversationWait)this.conversation_directory.get(conversationReturn);
                        if (rwaitReturn != null && !rwaitReturn.available_messages.isEmpty()) {
                            r = new Message(3001);
                            Message ret = (Message)rwaitReturn.available_messages.removeFirst();
                            if (conversationReturns.length() > 1) {
                                ret.append(conversationReturn);
                            }
                            r.append(ret);
                            mustWait = false;
                            break;
                        }
                        ++i;
                    }
                    if (mustWait) {
                        ConversationMember member = new ConversationMember(waiter_id, conversationReturns);
                        r = new Message(3002);
                        int i2 = 0;
                        while (i2 < conversationReturns.length()) {
                            String conversation_id = (String)conversationReturns.get(i2);
                            rwaitReturn = (ConversationWait)this.conversation_directory.get(conversation_id);
                            if (rwaitReturn == null) {
                                rwaitReturn = new ConversationWait();
                                this.conversation_directory.put(conversation_id, rwaitReturn);
                            }
                            rwaitReturn.waiting_runners.addLast(member);
                            member.conversation_waits.add(rwaitReturn);
                            ++i2;
                        }
                    } else if (r == null) {
                        r = new Message(3003);
                    }
                    if (extras.length() > 0) {
                        r.append(extras);
                    }
                }
            }
            if (type == 4197104) {
                Logger.info("CONTROLLER: Receive Message " + m);
                Long waiter_id = (Long)m.get(0);
                Message conversations = (Message)m.get(1);
                Object conversationReturns = this.conversation_directory_LOCK;
                synchronized (conversationReturns) {
                    ConversationWait rwait;
                    boolean mustWait = true;
                    r = null;
                    int i = 0;
                    while (i < conversations.length()) {
                        String conversation = (String)conversations.get(i);
                        rwait = (ConversationWait)this.conversation_directory.get(conversation);
                        if (rwait != null && !rwait.available_messages.isEmpty()) {
                            r = new Message(2801);
                            Message ret = (Message)rwait.available_messages.removeFirst();
                            if (conversations.length() > 1) {
                                ret.append(conversation);
                            }
                            r.append(ret);
                            mustWait = false;
                            break;
                        }
                        ++i;
                    }
                    if (mustWait) {
                        ConversationMember member = new ConversationMember(waiter_id, conversations);
                        r = new Message(2802);
                        int i3 = 0;
                        while (i3 < conversations.length()) {
                            String conversation2 = (String)conversations.get(i3);
                            rwait = (ConversationWait)this.conversation_directory.get(conversation2);
                            if (rwait == null) {
                                rwait = new ConversationWait();
                                this.conversation_directory.put(conversation2, rwait);
                            }
                            rwait.waiting_runners.addLast(member);
                            member.conversation_waits.add(rwait);
                            ++i3;
                        }
                    } else if (r == null) {
                        r = new Message(2803);
                    }
                }
            }
            if (type == 4197204) {
                Logger.info("CONTROLLER: Send Message " + m);
                String conversation = (String)m.get(0);
                Message msgdata = (Message)m.get(1);
                Long rid = (Long)m.get(2);
                long wakeup_id = 0L;
                Message wakeup_data = null;
                Object conversation2 = this.conversation_directory_LOCK;
                synchronized (conversation2) {
                    ConversationWait rwait = (ConversationWait)this.conversation_directory.get(conversation);
                    if (rwait == null) {
                        rwait = new ConversationWait();
                        this.conversation_directory.put(conversation, rwait);
                    }
                    if (rwait.waiting_runners.isEmpty()) {
                        rwait.available_messages.addLast(msgdata);
                        r = new Message(2901);
                    } else {
                        Long waiting_runner;
                        ConversationMember member = (ConversationMember)rwait.waiting_runners.getFirst();
                        if (member.conversations.length() > 1) {
                            msgdata.append(conversation);
                        }
                        if (ID.CONTROLLER_ID(waiting_runner = member.id) == ID.CONTROLLER_ID(rid)) {
                            Message extras = new Message(700);
                            extras.append(waiting_runner);
                            extras.append(msgdata);
                            r = new Message(2901);
                            r.append(extras);
                        } else {
                            try {
                                this.notifyMessageConsumer(waiting_runner, msgdata);
                                r = new Message(2901);
                            }
                            catch (Exception e) {
                                r = new Message(2902);
                                r.append(Logger.getStackTrace(e));
                            }
                        }
                        ArrayList obsolete_conversations = member.conversation_waits;
                        int i = 0;
                        while (i < obsolete_conversations.size()) {
                            ConversationWait cwait = (ConversationWait)obsolete_conversations.get(i);
                            cwait.waiting_runners.remove(member);
                            ++i;
                        }
                        if (Switches.MESSAGING_CONVERSATION_CLEANUP && rwait.available_messages.isEmpty() && rwait.waiting_runners.isEmpty()) {
                            this.conversation_directory.remove(conversation);
                        }
                    }
                }
                if (wakeup_data != null) {
                    try {
                        this.notifyMessageConsumer(wakeup_id, wakeup_data);
                    }
                    catch (Exception e) {
                        r = new Message(2902);
                        r.append(Logger.getStackTrace(e));
                    }
                }
            } else if (type == 4194804) {
                Logger.info("CONTROLLER: Wait Semaphore");
                Integer sid = (Integer)m.get(0);
                Integer waitcount = (Integer)m.get(1);
                Long rid = (Long)m.get(2);
                Semaphore s2 = null;
                Object mustWait = this.shared_sems_LOCK;
                synchronized (mustWait) {
                    s2 = (Semaphore)this.shared_sems.get(sid - 1);
                }
                r = s2.addWait(rid, waitcount) ? new Message(501) : new Message(503);
            } else if (type == 4194904) {
                Logger.info("CONTROLLER: Signal Semaphore");
                Integer sid = (Integer)m.get(0);
                Integer signalcount = (Integer)m.get(1);
                Semaphore s = null;
                Object s2 = this.shared_sems_LOCK;
                synchronized (s2) {
                    s = (Semaphore)this.shared_sems.get(sid - 1);
                }
                try {
                    s.addSignal(signalcount);
                    r = new Message(601);
                }
                catch (Exception e) {
                    r = new Message(602);
                    r.append(Logger.getStackTrace(e));
                }
            } else if (type == 4196104) {
                Logger.info("CONTROLLER: Retrieve (get) Hashmap");
                Integer hid = (Integer)m.get(0);
                String key = (String)m.get(1);
                try {
                    DataMap map = null;
                    Object e = this.shared_hashmaps_LOCK;
                    synchronized (e) {
                        map = (DataMap)this.shared_hashmaps.get(hid - 1);
                    }
                    Object val = map.get(key);
                    if (val == null) {
                        r = new Message(1803);
                        break block159;
                    }
                    r = new Message(1801);
                    if (val instanceof String) {
                        r.append((String)val);
                        break block159;
                    }
                    if (val instanceof Integer) {
                        r.append((Integer)val);
                        break block159;
                    }
                    if (val instanceof Long) {
                        r.append((Long)val);
                        break block159;
                    }
                    if (val instanceof Double) {
                        r.append((Double)val);
                        break block159;
                    }
                    if (val instanceof byte[]) {
                        r.append((byte[])val);
                        break block159;
                    }
                    if (val instanceof Message) {
                        r.append((Message)val);
                        break block159;
                    }
                    r = new Message(1802);
                    r.append("stored value in hashmap is of unrecognised type");
                }
                catch (Exception e) {
                    r = new Message(1802);
                    r.append(Logger.getStackTrace(e));
                }
            } else if (type == 4197704) {
                Logger.info("CONTROLLER: Retrieve Hashmap Key List");
                Integer hid = (Integer)m.get(0);
                try {
                    ArrayList list;
                    DataMap map = null;
                    Object val = this.shared_hashmaps_LOCK;
                    synchronized (val) {
                        map = (DataMap)this.shared_hashmaps.get(hid - 1);
                        list = new ArrayList(map.keySet());
                    }
                    r = new Message(3401);
                    int i = 0;
                    while (i < list.size()) {
                        r.append((String)list.get(i));
                        ++i;
                    }
                }
                catch (Exception e) {
                    r = new Message(3402);
                    r.append(Logger.getStackTrace(e));
                }
            } else if (type == 4196004) {
                Logger.info("CONTROLLER: Put Hashmap");
                Integer hid = (Integer)m.get(0);
                String newkey = (String)m.get(1);
                Object newval = m.get(2);
                try {
                    DataMap map = null;
                    Object mustWait = this.shared_hashmaps_LOCK;
                    synchronized (mustWait) {
                        map = (DataMap)this.shared_hashmaps.get(hid - 1);
                    }
                    map.put(newkey, newval);
                    r = new Message(1701);
                }
                catch (Exception e) {
                    r = new Message(1702);
                    r.append(Logger.getStackTrace(e));
                }
            } else if (type == 4195004) {
                Logger.info("CONTROLLER: Store Variable " + m);
                Integer vid = (Integer)m.get(0);
                Integer vtype = (Integer)m.get(1);
                Object newval = m.get(2);
                Variable v = null;
                this.shared_vars_MUTEX.lock();
                try {
                    v = (Variable)this.shared_vars.get(vid - 1);
                    this.shared_vars_MUTEX.release();
                }
                catch (Throwable e) {
                    this.shared_vars_MUTEX.release();
                    throw e;
                }
                Object object = v.LOCK;
                synchronized (object) {
                    block160: {
                        if (vtype.intValue() != v.getType()) {
                            r = new Message(702);
                            r.append("variable type does not match given type");
                        } else {
                            try {
                                switch (vtype) {
                                    case 0: {
                                        v.setValue((Integer)newval);
                                        break;
                                    }
                                    case 4: {
                                        v.setValue((String)newval);
                                        break;
                                    }
                                    case 5: {
                                        v.setValue((byte[])newval);
                                        break;
                                    }
                                    case 6: {
                                        v.setValue((Message)newval);
                                        break;
                                    }
                                    case 1: {
                                        v.setValue((Long)newval);
                                        break;
                                    }
                                    case 3: {
                                        v.setValue((Double)newval);
                                        break;
                                    }
                                    case 2: {
                                        v.setValue(new Float(((Double)newval).floatValue()));
                                        break;
                                    }
                                    default: {
                                        throw new ClassCastException("No recognised type");
                                    }
                                }
                                r = new Message(701);
                            }
                            catch (ClassCastException e) {
                                r = new Message(702);
                                r.append(Logger.getStackTrace(e));
                            }
                            try {
                                if (!v.getDirtyType()) break block160;
                                boolean[] hosts = v.getDirtyHosts();
                                Message n = new Message(400);
                                n.append(vid);
                                Message ret = null;
                                int i = 0;
                                while (i < hosts.length) {
                                    if (!hosts[i]) {
                                        hosts[i] = true;
                                        MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(i);
                                        ret = tc.doTransaction(n);
                                        if (ret.getType() != 401) {
                                            r = new Message(702);
                                            r.append("failed to notify all subcontrollers");
                                            break;
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                r = new Message(702);
                                r.append("failed to notify all subcontrollers");
                                r.append(Logger.getStackTrace(e));
                            }
                        }
                    }
                }
                Logger.info("CONTROLLER: End Of Store Variable");
            } else {
                if (type == 4196904) {
                    Logger.info("CONTROLLER: Join Runner");
                    Long waiter_id = (Long)m.get(0);
                    Long remote_id = (Long)m.get(1);
                    Object object = this.runner_directory_LOCK;
                    synchronized (object) {
                        RunnerWait rwait = (RunnerWait)this.runner_directory.get(remote_id);
                        if (rwait == null) {
                            r = new Message(2601);
                        } else {
                            r = new Message(2602);
                            rwait.waiting_runner = waiter_id;
                        }
                    }
                }
                if (type == 4196504) {
                    Logger.info("CONTROLLER: Clear Hashmap");
                    Integer hid = (Integer)m.get(0);
                    try {
                        DataMap map = null;
                        Object object = this.shared_hashmaps_LOCK;
                        synchronized (object) {
                            map = (DataMap)this.shared_hashmaps.get(hid - 1);
                        }
                        map.clear();
                        r = new Message(2201);
                    }
                    catch (Exception e) {
                        r = new Message(2202);
                        r.append(Logger.getStackTrace(e));
                    }
                } else {
                    r = new Message(-1);
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message doTransactionMediumPriority(Message m, int type) throws Throwable {
        Message r;
        if (type == 2097352) {
            Logger.info("CONTROLLER: Launch Runner");
            Integer count = (Integer)m.get(0);
            String method = (String)m.get(1);
            Integer host_index = (Integer)m.get(2);
            Message args = new Message();
            if (m.length() > 3) {
                args.appendAll((Message)m.get(3));
            }
            try {
                Message launched = this.launchRunner(host_index + 1, count, method, args);
                r = new Message(201);
                r.append(launched);
            }
            catch (NullPointerException e) {
                r = new Message(202);
                r.append("Did you remember to set the program + hosts before launching a runner?");
                r.append(Logger.getStackTrace(e));
            }
            catch (Exception e) {
                r = new Message(202);
                r.append(Logger.getStackTrace(e));
            }
        } else if (type == 2098052) {
            Logger.info("CONTROLLER: Get Variable");
            String vname = (String)m.get(0);
            Variable v = null;
            this.shared_vars_MUTEX.lock();
            try {
                v = (Variable)this.shared_vars_map.get(vname);
                this.shared_vars_MUTEX.release();
                if (v != null) {
                    v.MUTEX.lock();
                    v.MUTEX.release();
                }
            }
            catch (Throwable e) {
                this.shared_vars_MUTEX.release();
                throw e;
            }
            if (v == null) {
                r = new Message(902);
                r.append("Variable " + vname + " not found");
            } else {
                r = new Message(901);
                r.append(v.getID());
                r.append(v.getType());
            }
        } else if (type == 2098152) {
            Logger.info("CONTROLLER: Get Semaphore");
            String name = (String)m.get(0);
            Semaphore s = null;
            Object object = this.shared_sems_LOCK;
            synchronized (object) {
                s = (Semaphore)this.shared_sems_map.get(name);
            }
            if (s == null) {
                r = new Message(1002);
                r.append("Semaphore " + name + " not found");
            } else {
                r = new Message(1001);
                r.append(s.getID());
            }
        } else if (type == 2098752) {
            Logger.info("CONTROLLER: Get HashMap");
            String name = (String)m.get(0);
            DataMap map = null;
            Object object = this.shared_hashmaps_LOCK;
            synchronized (object) {
                map = (DataMap)this.shared_hashmaps_map.get(name);
            }
            if (map == null) {
                r = new Message(1602);
                r.append("HashMap " + name + " not found");
            } else {
                r = new Message(1601);
                r.append(map.getID());
            }
        } else {
            r = new Message(-1);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message doTransactionLowPriority(Message m, int type) throws Throwable {
        Message r;
        block69: {
            if (type == 1050876) {
                Logger.info("CONTROLLER: Get Hosts");
                r = new Message(2301);
                r.append(this.subcontrollers_hosts.size());
                int h = 0;
                while (h < this.subcontrollers_hosts.size()) {
                    r.append((String)this.subcontrollers_hosts.get(h));
                    ++h;
                }
            } else {
                if (type == 1050976) {
                    Logger.info("CONTROLLER: Get Variable List");
                    r = new Message(2401);
                    r.append(this.shared_vars.size());
                    this.shared_vars_MUTEX.lock();
                    try {
                        int v = 0;
                        while (v < this.shared_vars.size()) {
                            Variable var = (Variable)this.shared_vars.get(v);
                            r.append(var.getName());
                            ++v;
                        }
                        this.shared_vars_MUTEX.release();
                    }
                    catch (Throwable e) {
                        this.shared_vars_MUTEX.release();
                        throw e;
                    }
                }
                if (type == 0x10000A) {
                    Logger.info("CONTROLLER: Launch Program");
                    try {
                        this.launchProgram();
                        r = new Message(11);
                    }
                    catch (Exception e) {
                        r = new Message(12);
                        r.append(Logger.getStackTrace(e));
                    }
                } else {
                    if (type == 0x100190) {
                        Logger.info("CONTROLLER: New Semaphore");
                        String name = (String)m.get(0);
                        Integer initial = (Integer)m.get(1);
                        Object object = this.shared_sems_LOCK;
                        synchronized (object) {
                            Semaphore s = null;
                            s = (Semaphore)this.shared_sems_map.get(name);
                            if (s == null) {
                                int sid = this.shared_sems.size() + 1;
                                s = new Semaphore(name, sid, initial, this);
                                this.shared_sems.add(s);
                                this.shared_sems_map.put(name, s);
                                r = new Message(401);
                                r.append(s.id);
                            } else {
                                r = new Message(403);
                                r.append(s.id);
                            }
                        }
                    }
                    if (type == 1048876 || type == 1049676) {
                        boolean dirty = type == 1049676;
                        Logger.info("CONTROLLER: New Variable");
                        String vname = (String)m.get(0);
                        Integer vtype = (Integer)m.get(1);
                        try {
                            this.shared_vars_MUTEX.lock();
                            try {
                                Variable v = null;
                                v = (Variable)this.shared_vars_map.get(vname);
                                if (v == null) {
                                    int vid = this.shared_vars.size() + 1;
                                    v = new Variable(vname, vid, vtype);
                                    if (dirty) {
                                        v.setDirtyType(true);
                                        boolean[] b = new boolean[this.subcontrollers_client.size()];
                                        Arrays.fill(b, true);
                                        v.setDirtyHosts(b);
                                    } else {
                                        v.setDirtyType(false);
                                    }
                                    this.shared_vars.add(v);
                                    this.shared_vars_map.put(vname, v);
                                    v.MUTEX.lock();
                                    this.shared_vars_MUTEX.release();
                                    try {
                                        boolean notified = true;
                                        Message n = new Message(300);
                                        n.append(type);
                                        n.append(vname);
                                        n.append(vtype);
                                        n.append(v.id);
                                        int i = 0;
                                        while (i < this.subcontrollers_client.size()) {
                                            MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(i);
                                            Message ret = null;
                                            ret = tc.doTransaction(n);
                                            if (ret.getType() != 301) {
                                                notified = false;
                                            }
                                            ++i;
                                        }
                                        if (notified) {
                                            r = new Message(301);
                                            r.append(v.id);
                                        } else {
                                            r = new Message(302);
                                            r.append("could not notify all subcontrollers of the new variable");
                                        }
                                    }
                                    catch (Throwable t) {
                                        r = new Message(302);
                                        r.append(Logger.getStackTrace(t));
                                    }
                                    v.MUTEX.release();
                                    break block69;
                                }
                                r = new Message(303);
                                r.append(v.id);
                                this.shared_vars_MUTEX.release();
                                v.MUTEX.lock();
                                v.MUTEX.release();
                            }
                            catch (Throwable e) {
                                this.shared_vars_MUTEX.release();
                                r = new Message(302);
                                r.append(Logger.getStackTrace(e));
                            }
                        }
                        catch (Exception e) {
                            r = new Message(302);
                            r.append(Logger.getStackTrace(e));
                        }
                    } else if (type == 1050076) {
                        Logger.info("CONTROLLER: New HashMap");
                        String hname = (String)m.get(0);
                        try {
                            Object vname = this.shared_hashmaps_LOCK;
                            synchronized (vname) {
                                DataMap h = null;
                                h = (DataMap)this.shared_hashmaps_map.get(hname);
                                if (h == null) {
                                    int hid = this.shared_hashmaps.size() + 1;
                                    h = new DataMap(hname, hid);
                                    this.shared_hashmaps.add(h);
                                    this.shared_hashmaps_map.put(hname, h);
                                    r = new Message(1501);
                                    r.append(h.id);
                                } else {
                                    r = new Message(1503);
                                    r.append(h.id);
                                }
                            }
                        }
                        catch (Exception e) {
                            r = new Message(1502);
                            r.append(Logger.getStackTrace(e));
                        }
                    } else if (type == 1048676) {
                        Logger.info("CONTROLLER: Set Program");
                        try {
                            this.setProgram((byte[])m.get(0), (Message)m.get(1));
                            r = new Message(101);
                        }
                        catch (Exception e) {
                            r = new Message(102);
                            r.append(Logger.getStackTrace(e));
                        }
                    } else if (type == 1052276) {
                        Logger.info("CONTROLLER: Check JAR Dependencies Cache");
                        r = Controller.checkDependenciesCache(m);
                        r.setType(3701);
                    } else if (type == 0x10000A) {
                        Logger.info("CONTROLLER: Launch Program");
                        try {
                            this.launchProgram();
                            r = new Message(11);
                        }
                        catch (Exception e) {
                            r = new Message(12);
                            r.append(Logger.getStackTrace(e));
                        }
                    } else if (type == 2700) {
                        r = new Message(2700);
                        this.abortEngine();
                    } else if (type == 0x100E10) {
                        Logger.info("CONTROLLER: Set Headless");
                        try {
                            this.setHeadless((Integer)m.get(0) == 1);
                            r = new Message(3601);
                        }
                        catch (Exception e) {
                            r = new Message(3602);
                            r.append(Logger.getStackTrace(e));
                        }
                    } else if (type == 1051876) {
                        Logger.info("CONTROLLER: Set Log Level");
                        try {
                            this.setLogLevel((Integer)m.get(0) == 1, (Integer)m.get(1) == 1, (Integer)m.get(2) == 1);
                            r = new Message(3301);
                        }
                        catch (Exception e) {
                            r = new Message(3302);
                            r.append(Logger.getStackTrace(e));
                        }
                    } else if (type == 3500) {
                        try {
                            this.doRunnerStackTrace((Integer)m.get(0));
                        }
                        catch (Throwable t) {
                            Logger.error("Runner stacktrace failed", t);
                        }
                        r = new Message(3500);
                    } else if (type == 3100) {
                        try {
                            this.doRunnerStackdump();
                        }
                        catch (Throwable t) {
                            Logger.error("Runner stackdump failed", t);
                        }
                        r = new Message(3100);
                    } else {
                        r = new Message(-1);
                    }
                }
            }
        }
        return r;
    }

    public void abortEngine() {
        new AbortThread().start();
    }

    public Message doTransaction(Message m) {
        Message r;
        int type = m.getType();
        if (type == -2) {
            r = m;
        } else if (type == 1300) {
            this.clock = System.currentTimeMillis();
            Long offset = (Long)m.get(0);
            this.clock -= offset.longValue();
            try {
                int attempt = 0;
                int i = 1;
                while (i < this.subcontrollers_client.size()) {
                    MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(i);
                    long t = System.currentTimeMillis();
                    m = new Message(500);
                    m.append(0L);
                    r = tc.doTransaction(m);
                    t = System.currentTimeMillis() - t;
                    long rt = System.currentTimeMillis();
                    m = new Message(500);
                    m.append((t /= 2L) + (System.currentTimeMillis() - this.clock));
                    r = tc.doTransaction(m);
                    rt = System.currentTimeMillis() - rt;
                    double max = Math.max(rt /= 2L, t);
                    double min = Math.min(rt, t);
                    if (Math.abs(rt - t) > 10L) {
                        if (max / 10.0 < max - min || attempt < 2) {
                            --i;
                            ++attempt;
                        } else {
                            attempt = 0;
                        }
                    } else {
                        attempt = 0;
                    }
                    if (r.getType() != 501) {
                        throw new IOException("SubController clock sync failed - " + r);
                    }
                    ++i;
                }
                r = new Message(1301);
            }
            catch (IOException e) {
                r = new Message(1302);
                r.append(Logger.getStackTrace(e));
            }
        } else {
            try {
                if (type >= 0x400000) {
                    r = this.doTransactionHighPriority(m, type);
                } else if (type >= 0x200000) {
                    r = this.doTransactionMediumPriority(m, type);
                } else if (type >= 0x100000) {
                    r = this.doTransactionLowPriority(m, type);
                } else if (type < 0x100000) {
                    r = this.doTransactionHighPriority(m, type);
                    if (r.getType() == -1) {
                        r = this.doTransactionMediumPriority(m, type);
                    }
                    if (r.getType() == -1) {
                        r = this.doTransactionLowPriority(m, type);
                    }
                } else {
                    r = new Message(-1);
                    r.append("no recognised message priority");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                r = new Message(-3);
                r.append(Logger.getStackTrace(t));
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDebug(String s) {
        try {
            Message m = new Message(3200);
            m.append(s);
            Object object = LOCK_CLIENTS;
            synchronized (object) {
                int i = 0;
                while (i < this.clients_nout.size()) {
                    MTMessageWriter cwriter = (MTMessageWriter)this.clients_nout.get(i);
                    cwriter.write(m);
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDebug(String s) {
        try {
            Message m = new Message(3200);
            m.append(s);
            Object object = LOCK_CLIENTS;
            synchronized (object) {
                int i = 0;
                while (i < this.clients_nout.size()) {
                    MTMessageWriter cwriter = (MTMessageWriter)this.clients_nout.get(i);
                    cwriter.write(m);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {}
    }

    private void doRunnerStackTrace(int msg_id) throws IOException {
        Message m = new Message(1100);
        m.append(msg_id);
        int i = 0;
        while (i < this.subcontrollers_client.size()) {
            MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(i);
            tc.doTransaction(m);
            ++i;
        }
    }

    private void doRunnerStackdump() throws IOException {
        Message m = new Message(800);
        int i = 0;
        while (i < this.subcontrollers_client.size()) {
            MTTransactionClient tc = (MTTransactionClient)this.subcontrollers_client.get(i);
            tc.doTransaction(m);
            ++i;
        }
    }

    private void notifyMessageConsumer(long rid, Message data) throws IOException {
        int cindex = ID.CONTROLLER_INDEX(rid);
        MTTransactionClient stc = (MTTransactionClient)this.subcontrollers_client.get(cindex);
        Message m = new Message(700);
        m.append(rid);
        m.append(data);
        m = stc.doTransaction(m);
        int rtype = m.getType();
        if (rtype != 701) {
            throw new IOException("SubController receive message failed " + m);
        }
    }

    private void wakeRunner(long rid) throws IOException {
        int cindex = ID.CONTROLLER_INDEX(rid);
        MTTransactionClient stc = (MTTransactionClient)this.subcontrollers_client.get(cindex);
        Message m = new Message(600);
        m.append(rid);
        m = stc.doTransaction(m);
        int rtype = m.getType();
        if (rtype != 601) {
            throw new IOException("SubController wake runner failed " + m);
        }
    }

    class AbortThread
    extends Thread {
        boolean client_notifier = false;

        public AbortThread() {
        }

        private AbortThread(boolean notifier) {
            this.client_notifier = notifier;
        }

        public void run() {
            if (!this.client_notifier) {
                new AbortThread(true).start();
            }
            int i = 3;
            while (i > 0) {
                if (!this.client_notifier) {
                    Logger.direct("Aborting in " + i + "...");
                } else {
                    Controller.this.notifyDebug("Aborting in " + i + "...");
                }
                try {
                    Thread.sleep(750L);
                }
                catch (Exception exception) {}
                --i;
            }
            if (!this.client_notifier) {
                System.exit(0);
            }
        }
    }

    static class FileAgeComparator
    implements Comparator {
        FileAgeComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            return (int)(f1.lastModified() - f2.lastModified());
        }
    }

    class Reader
    extends Thread {
        MessageReader min;
        ThreadGroup tg;

        Reader(MessageReader min, ThreadGroup tg, String name) {
            super(tg, name);
            this.tg = tg;
            this.min = min;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread th = Thread.currentThread();
            th.setName("JEngine Controller [Daemon Server] Thread (ID: " + Controller.this.id + ") (" + Controller.this.actual_address + ")");
            try {
                Message m;
                while (true) {
                    MTMessageWriter cwriter;
                    int i;
                    Object object;
                    int type;
                    if ((type = (m = this.min.read()).getType()) == 1200) {
                        object = LOCK_CLIENTS;
                        synchronized (object) {
                            i = 0;
                            while (i < Controller.this.clients_nout.size()) {
                                try {
                                    cwriter = (MTMessageWriter)Controller.this.clients_nout.get(i);
                                    cwriter.write(m);
                                }
                                catch (Exception exception) {}
                                ++i;
                            }
                        }
                    }
                    if (type == 1400) {
                        if (!Controller.this.PRINT_INFO) continue;
                        object = LOCK_CLIENTS;
                        synchronized (object) {
                            i = 0;
                            while (i < Controller.this.clients_nout.size()) {
                                try {
                                    cwriter = (MTMessageWriter)Controller.this.clients_nout.get(i);
                                    cwriter.write(m);
                                }
                                catch (Exception exception) {}
                                ++i;
                            }
                        }
                    }
                    if (type == 3200) {
                        if (!Controller.this.PRINT_DEBUG) continue;
                        object = LOCK_CLIENTS;
                        synchronized (object) {
                            i = 0;
                            while (i < Controller.this.clients_nout.size()) {
                                try {
                                    cwriter = (MTMessageWriter)Controller.this.clients_nout.get(i);
                                    cwriter.write(m);
                                }
                                catch (Exception exception) {}
                                ++i;
                            }
                        }
                    }
                    if (type == 2500) {
                        Long lid = (Long)m.get(0);
                        Object object2 = Controller.this.runner_directory_LOCK;
                        synchronized (object2) {
                            if (Controller.this.runner_directory.get(lid) == null) {
                                Controller.this.runner_directory.put(lid, new RunnerWait());
                            } else {
                                RunnerWait rwait = (RunnerWait)Controller.this.runner_directory.remove(lid);
                                if (rwait.waiting_runner != -1L) {
                                    Controller.this.wakeRunner(rwait.waiting_runner);
                                }
                            }
                        }
                    }
                    if (type != 3100) break;
                    Controller.this.doRunnerStackdump();
                }
                throw new IOException("unrecognised message " + m);
            }
            catch (Throwable t) {
                this.tg.uncaughtException(this, t);
                return;
            }
        }
    }
}

