/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;


/**
 * @author amiguel
 * 
 * This interface should be implemented in much the same way as an
 * event handler.
 * 
 * The Message object recieved in doTransaction should be dealt with
 * and a response message should be returned to be sent back to the
 * client.
 */
public interface TransactionListener {

	/**
	 * Process a transaction. Imagine this method is called from the client.
	 * Process the message and return an appropriate message.
	 * @param m the Message from the client
	 * @return the response to send back to the client
	 */
	public Message doTransaction(Message m);

}//end interface
