/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mutex;

import java.util.HashMap;

/**
 * @author amiguel
 * 
 * A class that basically allows messages to be passed from one place to
 * another.
 *
 * Bob can write to the map under a certain key (e.g. a string or number)
 * 
 * Alice can at any time try to receive under that key and block until 
 * she gets it
 *
 * WARNING: this class does not do queueing, one person should write, the
 * other should read, 
 * 
 * @deprecated this class is probably not a great class to use, probably a far better idea to use the QueuedBlockingMap
 */
public class BlockingMap {

Object pool_LOCK = new Object();
HashMap pool = new HashMap();

	private void removeLock(Object key) {
		synchronized(pool_LOCK) {
			pool.remove(key);
		}
	}

	private Lock getLock(Object key) {
		Lock notifier;
		
		synchronized(pool_LOCK) {
			notifier = (Lock)pool.get(key);
			if (notifier == null) {
//System.out.println("GETLOCK:created new notifier for key "+key);			
				notifier = new Lock();
				pool.put(key,notifier);
			}
		}
		
		return notifier;
	}
	
	//non blocking
	public void put(Object key, Object value) throws InterruptedException {
	
		Lock notifier = getLock(key);

		synchronized(notifier) {
			notifier.value = value;
			
			if (notifier.waiting) {
//System.out.println("PUT:Something already waiting");			
				//something is already waiting
				notifier.notify();
				//ew've notified it
			} else {
//System.out.println("PUT:nothing waiting");			
				//nothing is waiting for the value yet
				notifier.populated = true;
			}
		}	
	}
	
	public Object get(Object key) throws InterruptedException {

		Object value;

		Lock notifier = getLock(key);

		synchronized(notifier) {
			
			if (notifier.populated) {
//System.out.println("GET:value already there");			
				//already a value there
			} else {
//System.out.println("GET:need to wait for value");			
				//need to wait for a value
				notifier.waiting = true;
				notifier.wait();
				//we've been notified - there will be a value now
			}
		
			value = notifier.value;

		}
		
		removeLock(key);

		return value;		
	}

	class Lock {
		boolean waiting = false;
		boolean populated = false;
		boolean return_waiting = false;
		Object value;
	}	
/*

	private static final int TEST_PUT=0;
	private static final int TEST_GET=1;

	public static void main(String[] args) {
		BlockingMap map = new BlockingMap();
		
		for (int i = 0; i < 10000; i++) {
		
			String key = "key"+i;
			String value = "value"+i;
		
			Thread t1 = new TestThread(map,TEST_GET,key,value);
			Thread t2 = new TestThread(map,TEST_PUT,key,value);
			
			t1.start();
			t2.start();
		}
	}

	private static class TestThread extends Thread {
		int type;
		Object key,value;
		BlockingMap map;
		public TestThread(BlockingMap map, int type, Object key, Object value) {
			this.type = type;
			this.key = key;
			this.value = value;
			this.map = map;
		}
		public void run() {
			try {
				Thread.sleep((int)(Math.random()*50));
			
				if (type == TEST_PUT) {
					System.out.println("PUT "+key+" -> "+value);
					map.put(key,value);				
					System.out.println("PUT RETURN "+key+" -> "+value);
				} else if (type == TEST_GET) {
					System.out.println("GET "+key+" -> "+value);
					Object val = map.get(key);
//					System.out.println(map.get(key)+" == "+value);
					if (!val.equals(value)) {
						System.out.println("MISMATCH! "+value+" != "+val);
					}
				}
			} catch (Throwable t) {
				t.printStackTrace();
			}
		}
	}*/
}
