/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.launchconfig;

import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.stp.b2j.ui.B2jImageManager;
import org.eclipse.stp.b2j.ui.UiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class LaunchConfigAssetsTab extends AbstractLaunchConfigurationTab implements ILaunchConfigurationTab, SelectionListener, KeyListener {

Composite main_panel;
Label bpel_label;
Text bpel_file;
Button bpel_browse;
Label service_label;
List service_files;
Button service_add;
Button service_remove;

String message;
String error_message;

	public void checkForErrors() {
		error_message = null;
	}

	public boolean isValid(ILaunchConfiguration launchConfig) {
		return error_message == null;
	}
	
	public String getErrorMessage() {
		return error_message;
	}
	
	public String getMessage() {
		return message;
	}
	
	public void setDirty(boolean b) {
		super.setDirty(b);
		checkForErrors();
		updateLaunchConfigurationDialog();
	}

	
	public void createControl(Composite parent) {
		
		main_panel = new Composite(parent,0);
		main_panel.setLayout(new GridLayout(4,false));
		
		bpel_label = new Label(main_panel,SWT.NONE);
		bpel_label.setText(UiPlugin.getString("BPEL_FILE"));
		bpel_label.setLayoutData(new GridData(GridData.BEGINNING,GridData.END,false,false,4,1));
		
		bpel_file = new Text(main_panel,SWT.BORDER);
		bpel_file.setLayoutData(new GridData(GridData.FILL,GridData.FILL,true,false,3,1));

//		public GridData(int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int verticalSpan) {

		bpel_browse = new Button(main_panel,SWT.NONE);
		bpel_browse.setText(UiPlugin.getString("BROWSE"));
		bpel_browse.setLayoutData(new GridData(GridData.FILL,GridData.FILL,false,false,1,1));
		
		service_label = new Label(main_panel,SWT.NONE);
		service_label.setText(UiPlugin.getString("SERVICE_FILES"));
		service_label.setLayoutData(new GridData(GridData.BEGINNING,GridData.END,false,false,4,1));
		
		service_files = new List(main_panel,SWT.BORDER|SWT.MULTI);
		service_files.setLayoutData(new GridData(GridData.FILL,GridData.FILL,true,true,3,3));
		
		service_add = new Button(main_panel,SWT.NONE);
		service_add.setText(UiPlugin.getString("SERVICE_ADD"));
		service_add.setLayoutData(new GridData(GridData.FILL,GridData.FILL,false,false,1,1));
		
		service_remove = new Button(main_panel,SWT.NONE);
		service_remove.setText(UiPlugin.getString("SERVICE_REMOVE"));
		service_remove.setLayoutData(new GridData(GridData.FILL,GridData.FILL,false,false,1,1));
		
		
		//
		// Event handling
		//
		bpel_file.addKeyListener(this);
		
		bpel_browse.addSelectionListener(this);
		service_remove.addSelectionListener(this);
		service_add.addSelectionListener(this);
	}
	
	public Control getControl() {
		return main_panel;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute("bpel_file","");
		configuration.setAttribute("service_files",new ArrayList());
	}

	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			String sbpel_file = configuration.getAttribute("bpel_file","");
			java.util.List sservice_files = configuration.getAttribute("service_files",new ArrayList());
			
			String[] items = new String[sservice_files.size()];
			for (int i = 0; i < items.length; i++) {
				items[i] = (String)sservice_files.get(i);
			}
			
			bpel_file.setText(sbpel_file);
			service_files.setItems(items);
			
		} catch (CoreException e) {
			 e.printStackTrace();
		}
		checkForErrors();
	}

	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		ArrayList list = new ArrayList();
		String[] items = service_files.getItems();
		for (int i = 0; i < items.length; i++) {
			list.add(items[i]);
		}
		
		configuration.setAttribute("bpel_file",bpel_file.getText());
		configuration.setAttribute("service_files",list);
	}

	public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
		initializeFrom(workingCopy);
	}
	
	public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
		performApply(workingCopy);
	}
	
	public String getName() {
		return UiPlugin.getString("ASSETS_TAB_NAME");
	}

	public Image getImage() {
		return UiPlugin.imageManager.getImage(B2jImageManager.IMG_SERVICES);
	}
	
	public void dispose() {
		try {
			main_panel.dispose();
		} catch (Exception e) {
		}
	}

	//
	// Event handlers
	//
	
	public void keyPressed(KeyEvent e) {
		setDirty(true);
	}

	public void keyReleased(KeyEvent e) {
		setDirty(true);
	}

	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == bpel_browse) {
			ResourceSelectionDialog dialog = new ResourceSelectionDialog(main_panel.getShell(),ResourcesPlugin.getWorkspace().getRoot(),UiPlugin.getString("BROWSE_BPEL_MSG"));
			//dialog.setInitialSelections(..);
			
			dialog.open();
			
			Object[] resources = dialog.getResult();
			
			if (resources.length == 1) {
				IResource resource = (IResource)resources[0];
				System.out.println(resource.getFullPath());
				
				bpel_file.setText(resource.getFullPath().toString());
				
			} else {
				MessageBox mbox = new MessageBox(main_panel.getShell(),SWT.NONE);
				mbox.setMessage(UiPlugin.getString("ERROR_ONE_BPEL"));
				mbox.setText(UiPlugin.getString("ERROR"));
				mbox.open();
			}
			
			setDirty(true);

		} else if (o == service_add) {
			ResourceSelectionDialog dialog = new ResourceSelectionDialog(main_panel.getShell(),ResourcesPlugin.getWorkspace().getRoot(),UiPlugin.getString("BROWSE_BPEL_MSG"));
			//dialog.setInitialSelections(..);
			
			dialog.open();
			
			Object[] resources = dialog.getResult();
			
			for (int i = 0; i < resources.length; i++) {
				IResource resource = (IResource)resources[i];
				System.out.println(resource.getFullPath());
				
				String[] items = service_files.getItems();
				
				boolean found = false;
				for (int k = 0; k < items.length; k++) {
					if (items[k].equals(resource.getFullPath().toString())) {
						found = true;
						break;
					}
				}
				
				if (!found) {
					service_files.add(resource.getFullPath().toString());
				}
			}
			
			setDirty(true);

		} else if (o == service_remove) {
			int[] selected = service_files.getSelectionIndices();
			Arrays.sort(selected);
			for (int i = selected.length-1; i >= 0; i--) {
				service_files.remove(selected[i]);
			}
			
			setDirty(true);
		}
		
		checkForErrors();
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
}