/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.preferences;

import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportProvider;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;

public class PreferenceConstants {
	public static final String USE_PROXY = "use_proxy";
	public static final String PROXY_PORT = "proxy_host";
	public static final String PROXY_HOST = "proxy_port";
	public static final String USE_CACHE = "use_cache";

	public static final String CACHE_SIZE = "cache_size";
	public static final String CACHE_LOCATION = "cache_location";
	public static final String CACHE_CONTENT = "cache_content";

	public static final String TRANSPORT_ENABLED = "transport_enabled";
	public static final String BINDING_ENABLED = "binding_enabled";

	public static String getTransportEnabledKey(SessionTransportProvider provider) {
		return PreferenceConstants.TRANSPORT_ENABLED+provider.getProviderClassName();
	}
	public static String getBindingEnabledKey(WSDLBindingTranslator translator) {
		return PreferenceConstants.BINDING_ENABLED+translator.getID();
	}
}