/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDeleteAnnotationAction
extends AbstractActionHandler {
    private EModelElement selectedElt;
    private IGraphicalEditPart selectedPart;

    public AbstractDeleteAnnotationAction(IWorkbenchPage page) {
        super(page);
    }

    public AbstractDeleteAnnotationAction(IWorkbenchPart part) {
        super(part);
    }

    public void doRun(IProgressMonitor progressMonitor) {
        IDiagramEditDomain diagramEditDomain = this.selectedPart.getDiagramEditDomain();
        CompoundCommand co = new CompoundCommand("Setting the pool to be executable");
        co.add((Command)new ICommandProxy(this.deleteAnnotation()));
        co.add(new Command(){

            public void execute() {
                AbstractDeleteAnnotationAction.this.getSelectedPart().refresh();
            }
        });
        diagramEditDomain.getDiagramCommandStack().execute((Command)co, progressMonitor);
    }

    private ICommand deleteAnnotation() {
        if (this.selectedElt.getEAnnotation(this.getAnnotationSource()) != null) {
            DestroyElementRequest request = new DestroyElementRequest((EObject)this.selectedElt.getEAnnotation(this.getAnnotationSource()), true);
            DestroyElementCommand command = new DestroyElementCommand(request);
            return command;
        }
        return null;
    }

    public void refresh() {
        ISelection selection = this.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            this.setEnabled(false);
            return;
        }
        this.updateSelectedEModelElement(this.getSelection());
        boolean ok = this.selectedElt != null && this.selectedPart != null;
        this.setEnabled(ok);
        if (ok) {
            this.setText(this.updateText(this.selectedElt));
            this.setImageDescriptor(this.updateImage(this.selectedElt));
            this.setDescription(this.updateDescription(this.selectedElt));
            this.setToolTipText(this.updateToolTipText(this.selectedElt));
        } else {
            this.setText(this.getDefaultLabel());
            this.setImageDescriptor(this.getDefaultImage());
            this.setDescription(this.getDefaultDescription());
            this.setToolTipText(this.getDefaultToolTipText());
        }
    }

    protected String updateToolTipText(EModelElement elt) {
        return null;
    }

    protected String updateDescription(EModelElement elt) {
        return null;
    }

    protected abstract String updateText(EModelElement var1);

    protected abstract ImageDescriptor updateImage(EModelElement var1);

    protected void updateSelectedEModelElement(ISelection selection) {
        EModelElement elt;
        IGraphicalEditPart part;
        if (selection != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IGraphicalEditPart && (part = (IGraphicalEditPart)((IStructuredSelection)selection).getFirstElement()) != null && part.getNotationView() != null && (elt = (EModelElement)part.getNotationView().getElement()).getEAnnotation(this.getAnnotationSource()) != null) {
            this.selectedElt = elt;
            this.selectedPart = part;
            return;
        }
        this.selectedElt = null;
        this.selectedPart = null;
    }

    protected abstract String getAnnotationSource();

    protected String getDefaultLabel() {
        return "Delete Annotation";
    }

    protected String getDefaultToolTipText() {
        return "No annotation are attached to this element";
    }

    protected ImageDescriptor getDefaultImage() {
        return null;
    }

    protected String getDefaultDescription() {
        return "No annotation are attached to this element";
    }

    protected EModelElement getSelectedElt() {
        return this.selectedElt;
    }

    protected void setSelectedElt(EModelElement selectedElt) {
        this.selectedElt = selectedElt;
    }

    public IGraphicalEditPart getSelectedPart() {
        return this.selectedPart;
    }

    public void setSelectedPart(IGraphicalEditPart selectedPart) {
        this.selectedPart = selectedPart;
    }
}

