/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.commands;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class SetBoundsCommandEx
extends SetBoundsCommand {
    private GraphicalEditPart editPart;
    private Rectangle bounds;

    public SetBoundsCommandEx(TransactionalEditingDomain editingDomain, String label, GraphicalEditPart editPart, Rectangle bounds) {
        super(editingDomain, label, (IAdaptable)editPart, bounds);
        this.editPart = editPart;
        this.bounds = bounds;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Dimension size;
        EditPart parent = this.editPart.getParent();
        if (parent instanceof ShapeCompartmentEditPart) {
            ((ShapeCompartmentEditPart)parent).propertyChange(new PropertyChangeEvent(this.editPart, "childResized", null, this.bounds.getCopy()));
        }
        if (this.bounds.x < 0) {
            this.bounds.x = 0;
        }
        if (this.bounds.y < 0) {
            this.bounds.y = 0;
        }
        if (this.editPart == null) {
            return CommandResult.newErrorCommandResult((String)"SetBoundsCommand: viewAdapter does not adapt to IView.class");
        }
        View view = (View)this.editPart.getAdapter(View.class);
        Point location = this.bounds.getLocation();
        if (location != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)new Integer(location.x));
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)new Integer(location.y));
        }
        if ((size = this.bounds.getSize()) != null) {
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)new Integer(size.width));
            ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)new Integer(size.height));
        }
        return CommandResult.newOKCommandResult();
    }
}

