/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.palette;

import java.lang.reflect.Field;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.internal.ui.palette.editparts.DetailedLabelFigure;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.stp.bpmn.palette.BpmnPaletteViewer;
import org.eclipse.stp.bpmn.palette.IStickableToolEntry;
import org.eclipse.stp.bpmn.palette.ToolEntryFigureInactiveToggleButton;
import org.eclipse.swt.graphics.Color;

public class BpmnToolEntryEditPart
extends ToolEntryEditPart {
    private static Field customLabelField;
    private static Field detailedLabelNameTextField;
    private static Field paragraphTextLayoutWrapStyleField;
    Color _backgroundColor;
    Color _foregroundColor;
    static final Border BORDER_TOGGLE;
    static final Border COLUMNS_BORDER;

    static {
        BORDER_TOGGLE = new ButtonBorder(ButtonBorder.SCHEMES.TOOLBAR);
        COLUMNS_BORDER = new MarginBorder(2, 0, 1, 0);
    }

    private static void init() {
        if (customLabelField != null) {
            return;
        }
        try {
            customLabelField = ToolEntryEditPart.class.getDeclaredField("customLabel");
            customLabelField.setAccessible(true);
            detailedLabelNameTextField = DetailedLabelFigure.class.getDeclaredField("nameText");
            detailedLabelNameTextField.setAccessible(true);
            paragraphTextLayoutWrapStyleField = ParagraphTextLayout.class.getDeclaredField("wrappingStyle");
            paragraphTextLayoutWrapStyleField.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public BpmnToolEntryEditPart(PaletteEntry paletteEntry, Color foregroundColor, Color backgroundColor) {
        super(paletteEntry);
        this._foregroundColor = foregroundColor;
        this._backgroundColor = backgroundColor;
        BpmnToolEntryEditPart.init();
    }

    public IFigure createFigure() {
        DetailedLabelFigure customLabel = new DetailedLabelFigure();
        this.setCustomLabel(customLabel);
        ToolEntryFigureInactiveToggleButton button = new ToolEntryFigureInactiveToggleButton(this, (IFigure)customLabel);
        try {
            TextFlow theNameText = (TextFlow)detailedLabelNameTextField.get(customLabel);
            ParagraphTextLayout txtLayout = (ParagraphTextLayout)theNameText.getLayoutManager();
            paragraphTextLayoutWrapStyleField.setInt(txtLayout, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BpmnPaletteViewer bpmnPaletteViewer = (BpmnPaletteViewer)BpmnToolEntryEditPart.this.getViewer();
                bpmnPaletteViewer.setActiveTool(BpmnToolEntryEditPart.this.getToolEntry());
            }
        });
        return button;
    }

    private ToolEntry getToolEntry() {
        return (ToolEntry)this.getModel();
    }

    protected void setCustomLabel(DetailedLabelFigure customLabel) {
        try {
            customLabelField.set((Object)this, customLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ButtonModel getButtonModel() {
        Clickable c = (Clickable)this.getFigure();
        return c.getModel();
    }

    public void setToolSelected(boolean value) {
        ToolEntryFigureInactiveToggleButton tog = (ToolEntryFigureInactiveToggleButton)this.getFigure();
        tog.isSticky = this.getModel() instanceof IStickableToolEntry ? ((IStickableToolEntry)this.getModel()).isSticky() : false;
        this.getButtonModel().setSelected(value);
        this.getFigure().setOpaque(value);
    }

    protected IFigure createToolTip() {
        return super.createToolTip();
    }
}

