/**
 * Copyright (C) 2000-2007, Intalio Inc.
 *
 * The program(s) herein may be used and/or copied only with the
 * written permission of Intalio Inc. or in accordance with the terms
 * and conditions stipulated in the agreement/contract under which the
 * program(s) have been supplied.
 *
 * Dates       		 Author              Changes
 * Feb 20, 2007      Antoine Toulmé   Creation
 */
package org.eclipse.stp.bpmn.diagram.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Hides the decorations by setting a value in the preference store.
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulmé</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class FilterDecorationsAction extends AbstractActionHandler {
	
	public static final String ID = "FilterDecorationsAction";
	
	
	public FilterDecorationsAction(IWorkbenchPart workbenchPart) {
		super(workbenchPart);
	}
	
	public FilterDecorationsAction(IWorkbenchPage workbenchPage) {
		super(workbenchPage);
	}
	/**
	 * Inits the action with its id, description, tooltip and image.
	 */
	@Override
	public void init() {
		
		setId(ID);
		setDescription("Hide or shows decorations");
		setToolTipText(getDescription());
		setText(getDescription());
		super.init();
		setEnabled(true);
		// explicitly calling refresh to have a text for the action.
		refresh();
	}
	/**
	 * Runs the operation, basically invert the value of isDefault 
	 * property on the sequence edge.
	 */
	@Override
	protected void doRun(IProgressMonitor progressMonitor) {
		boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().
		getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS);
		BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().setValue(
				BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS, !b);
		refresh();
		
		RootEditPart part = ((IGraphicalEditPart) getStructuredSelection().getFirstElement()).getRoot();
		part.refresh();
		recursiveRefresh(part);
	}

	/**
	 * recursively refreshes the edit parts, so that
	 * decorations are hidden or shown.
	 * @param part
	 */
	private void recursiveRefresh(EditPart part) {
		for (Object child : part.getChildren()) {
			((EditPart) child).refresh();
			recursiveRefresh((EditPart) child);
		}
	}
	/**
	 * Refreshes the action according to the value hold
	 * in the preference store
	 */
	public void refresh() {
		if (getSelection().isEmpty() || 
				!(getSelection() instanceof IStructuredSelection) ||
				(!(((IStructuredSelection)getSelection()).getFirstElement() instanceof EditPart))) {
			return;
		}
		boolean b = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().
		getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS);
		if (b) {
			setText("Show unfiltered decorations");
			setDescription(getText());
			setToolTipText(getText());
			setImageDescriptor(BpmnDiagramEditorPlugin.
					getBundledImageDescriptor("icons/obj16/showDecorations.gif"));
		} else {
			setText("Hide all decorations");
			setDescription(getText());
			setToolTipText(getText());
			setImageDescriptor(BpmnDiagramEditorPlugin.
					getBundledImageDescriptor("icons/obj16/hideDecorations.gif"));
		}
		setEnabled(true);
	} 
}
