/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

/** 
 * Date                 Author              Changes 
 * 17 Nov 2006      MPeleshchyshyn      Created 
 **/
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.RequestConstants;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.commands.CreateSubProcessCommand;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/**
 * This class groups actions
 * 
 * @author MPeleshchyshyn
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class GroupAction extends AbstractGroupUngroupAction {
    public static final String ACTION_ID = "groupAction";

    public static final String TOOLBAR_ACTION_ID = "toolbarGroupAction";

    static final String ICON_PATH = "icons/Group.gif";

    private static final String ACTION_TEXT = "Group";

    static final String TOOLTIP_TEXT = "Group Shapes(Create Sub-Process)";

    public GroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public GroupAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    private static GroupAction createActionWithoutId(
            IWorkbenchPage workbenchPage) {
        GroupAction action = new GroupAction(workbenchPage);
        action.setText(ACTION_TEXT);
        action.setToolTipText(TOOLTIP_TEXT);
        action.setImageDescriptor(BpmnDiagramEditorPlugin
                .getBundledImageDescriptor(ICON_PATH));

        return action;
    }

    public static GroupAction createGroupAction(IWorkbenchPage workbenchPage) {
        GroupAction action = createActionWithoutId(workbenchPage);
        action.setId(ACTION_ID);

        return action;
    }

    public static GroupAction createToolbarGroupAction(
            IWorkbenchPage workbenchPage) {
        GroupAction action = createActionWithoutId(workbenchPage);
        action.setId(TOOLBAR_ACTION_ID);

        return action;
    }

    /**
     * Edit part to be grouped
     */
    private List<GraphicalEditPart> editParts = new ArrayList<GraphicalEditPart>();
    /**
     * Edit part that are boundary events of a sub-process that belongs to the shapes being grouped.
     * It is necessary to consider those when computing the internal connections.
     * See EDGE-1108
     */
    private List<IGraphicalEditPart> almostSelectedBoundaryEvents = new ArrayList<IGraphicalEditPart>();

    /**
     * External source connections
     */
    private Collection<SequenceEdgeEditPart> externalSrcConnections = new ArrayList<SequenceEdgeEditPart>();

    /**
     * External target connections
     */
    private Collection<SequenceEdgeEditPart> externalTgtConnections = new ArrayList<SequenceEdgeEditPart>();

    /**
     * Internal connections - between edit parts to be grouped
     */
    private Collection<SequenceEdgeEditPart> internalConnections = new HashSet<SequenceEdgeEditPart>();

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    @Override
    protected void doRun(final IProgressMonitor progressMonitor) {

    	IGraphicalEditPart firstEditPart = editParts.get(0);
    	AbstractTransactionalCommand undoableCommand = new AbstractTransactionalCommand(firstEditPart.getEditingDomain(), "Grouping shapes", null) {

    		@Override
    		protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) {


    			// common parent of selected edit part now will become a parent for new
    			// subprocess
    			final EditPart containerEditPart = editParts.get(0).getParent();

    			// first let's create new sub-process
    			final CreateViewRequest req = CreateViewRequestFactory.
    			getCreateShapeRequest(BpmnElementTypes.SubProcess_2002, 
    					BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
    			// get to the semantic command to add a parameter to skip
    			// the subprocess from being added a child by default
    			for (Object desc : req.getViewDescriptors()) {
    				CreateElementRequest createSubProcessSemanticRequest =
    					(CreateElementRequest) ((ViewDescriptor) desc).
    					getElementAdapter().getAdapter(CreateElementRequest.class);
    				createSubProcessSemanticRequest.setParameter(
    						CreateSubProcessCommand.CREATE_CHILD_PARAMETER, 
    						Boolean.FALSE);
    			}


    			Rectangle rect = getSizeAndLocation(req);
    			Command create = containerEditPart.getCommand(req);
    			create.execute();
    			final Node spview = (Node) ((IAdaptable) ((List) req.getNewObject()).get(0)).
    			getAdapter(Node.class);
    			
//    			 retargeting connections.

    			for (SequenceEdgeEditPart part : externalSrcConnections) {
    				SequenceEdge edge = (SequenceEdge) part.
    				resolveSemanticElement();
//    				DestroyElementRequest request = new DestroyElementRequest(edge, false);
//    		    	Command destroy = part.getCommand(new EditCommandRequestWrapper(request));
    				edge.setSource((Vertex) spview.getElement());
    				((Edge) part.getNotationView()).setSource(spview);
//    		    	destroy.execute();
    			}
    			for (SequenceEdgeEditPart part : externalTgtConnections) {
    				SequenceEdge edge = (SequenceEdge) part.
    				resolveSemanticElement();
//    				DestroyElementRequest request = new DestroyElementRequest(edge, false);
//    		    	Command destroy = part.getCommand(new EditCommandRequestWrapper(request));
    				edge.setTarget((Vertex) spview.getElement());
    				((Edge) part.getNotationView()).setTarget(spview);
//    		    	destroy.execute();
    			}
    			
    			Bounds b = NotationFactory.eINSTANCE.createBounds();
    			b.setX(rect.x);
    			b.setY(rect.y);
    			b.setHeight(rect.height);
    			b.setWidth(rect.width);
    			spview.setLayoutConstraint(b);

    			View compartmentView = null;
    			String compartmentId = Integer.
    			toString(SubProcessSubProcessBodyCompartmentEditPart.VISUAL_ID);
    			for (Object spchild : spview.getChildren()) {
    				View vchild = (View) spchild;
    				if (compartmentId.equals(vchild.getType())) {
    					compartmentView = vchild;
    					break;
    				}
    			}


    			final List<EObject> semantic = new LinkedList<EObject>(); 
    			Location sploc = (Location) spview.getLayoutConstraint();
    			
    			for (GraphicalEditPart part : editParts) {
    				View v = (View) part.getModel();
    				semantic.add(part.resolveSemanticElement());
    				compartmentView.insertChild(v);
    				
    				if (v instanceof Node) {
    					Bounds constraint = (Bounds) ((Node) v).getLayoutConstraint();

    					constraint.setX(constraint.getX() - sploc.getX());
    					constraint.setY(constraint.getY() - sploc.getY());
    					if (constraint.getX() < 0) {
    						constraint.setX(0);
    					}
    					if (constraint.getY() < 0) {
    						constraint.setY(0);
    					}
    				}
    			}
    			
    			for (SequenceEdgeEditPart part : internalConnections) {
    				SequenceEdge edge = (SequenceEdge) part.resolveSemanticElement();
    				((Graph) spview.getElement()).getSequenceEdges().add(edge);
    			}

    			
    			for (EObject obj : semantic) {
    				if (obj instanceof Activity) {
    					List incoming = new ArrayList(((Activity) obj).getIncomingEdges());
    					List outgoing = new ArrayList(((Activity) obj).getOutgoingEdges());
    					((Activity) obj).getIncomingEdges().clear();
    					((Activity) obj).getOutgoingEdges().clear();
    					Graph graph = ((Activity) obj).getGraph();
    					graph.getVertices().remove(obj);
    					((Activity) obj).setGraph(null);
    					
    					((Activity) obj).setGraph((Graph) spview.getElement());
    					((Activity) obj).getIncomingEdges().addAll(incoming);
    					((Activity) obj).getOutgoingEdges().addAll(outgoing);
    				} else {
    					spview.getElement().eContents().add(obj);
    				}
    			}

    			// refreshing the result to clean the edit parts
    			Command command = containerEditPart.getCommand(new Request(RequestConstants.REQ_REFRESH)); 
    	    	command.execute();

    	    	
    			for (SequenceEdgeEditPart part : externalSrcConnections) {
    				part.refresh();
    				part.activate();
    			}
    			
    			for (SequenceEdgeEditPart part : externalTgtConnections) {
    				part.refresh();
    				part.activate();
    			}
    			
    			for (GraphicalEditPart p : editParts) {
    				for (Object connection : p.getTargetConnections()) {
    					((EditPart) connection).refresh();
    					((EditPart) connection).activate();
    				}
    				for (Object connection : p.getSourceConnections()) {
    					((EditPart) connection).refresh();
    					((EditPart) connection).activate();
    				}
    			}
    			return CommandResult.newOKCommandResult();
    		}};

    		firstEditPart.getDiagramEditDomain().
    			getDiagramCommandStack().execute(
    				new ICommandProxy(undoableCommand));
    }

    private Rectangle getSizeAndLocation(CreateViewRequest req) {
		int x = 0;
		int y = 0;
		int width = 0;
		int height = 0;
		boolean firstTime = true;
    	for (GraphicalEditPart part : editParts) {
			if (part.getNotationView() instanceof Node) {
				Object constraint = ((Node) part.getNotationView()).getLayoutConstraint();
				if (constraint instanceof Location) {
					if (firstTime) {
						firstTime = false;
						x = ((Location) constraint).getX();
						y = ((Location) constraint).getY();
					} else {
						x = Math.min(((Location) constraint).getX(), x);
						y = Math.min(((Location) constraint).getY(), y);
					}
				}
					
				if (constraint instanceof Bounds) {
					int w = ((Bounds) constraint).getWidth();
					// autosize is definitively in need to be implemented.
					// in the mean time, the view is initialized with a -1 -1 size
					// and we have to rely on the figure and dirty hacks...
					if (w == -1) {
						w = part.getFigure().getBounds().width;
					}
					int h = ((Bounds) constraint).getHeight();
					if (h == -1) {
						h = part.getFigure().getBounds().height;
					}
					width = Math.max(width, w + 
							((Bounds) constraint).getX());
					height = Math.max(height, h + 
							((Bounds) constraint).getY());
				}
			}
		}
    	width -= x;
    	height -= y;
		height += 32; // border. 
		// insets
		height += SubProcessEditPart.INSETS.top + 
			SubProcessEditPart.INSETS.bottom;
		
		width += SubProcessEditPart.INSETS.left + 
			SubProcessEditPart.INSETS.right;
		Point pt = new Point(x, y);
		return new Rectangle(pt, new Dimension(width, height));
	}

    /**
     * Checks all source and target connections of the specified edit part and
     * sets it into one of the specified collections. If connection connects the
     * specified object with some other selected element it is added to internal
     * connection. In other case it is added to external source or external
     * target connections.
     * 
     * @param editPart
     *            the edit part
     * @param internalConnections
     *            set that holds internal connections
     * @param externalSrcConnection
     *            holds external source connections
     * @param externalTgtConnections
     *            holds external target connections
     */
    private void sortConnections(IGraphicalEditPart editPart,
            Collection<SequenceEdgeEditPart> internalConnections,
            Collection<SequenceEdgeEditPart> externalSrcConnection,
            Collection<SequenceEdgeEditPart> externalTgtConnections) {
        List srcConnections = editPart.getSourceConnections();
        for (Object connection : srcConnections) {
            if (connection instanceof SequenceEdgeEditPart) {
                SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart) connection;
                if (editParts.contains(sequenceConnection.getTarget()) ||
                        almostSelectedBoundaryEvents.contains(
                                sequenceConnection.getTarget())) {
                    internalConnections.add(sequenceConnection);
                } else {
                    externalSrcConnection.add(sequenceConnection);
                }
            }
        }
        List targetConnections = editPart.getTargetConnections();
        for (Object connection : targetConnections) {
            if (connection instanceof SequenceEdgeEditPart) {
                SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart) connection;
                if (editParts.contains(sequenceConnection.getSource()) ||
                        almostSelectedBoundaryEvents.contains(
                                sequenceConnection.getSource())) {
                    internalConnections.add(sequenceConnection);
                } else {
                    externalTgtConnections.add(sequenceConnection);
                }
            }
        }
    }

    

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void refresh() {
        editParts.clear();
        almostSelectedBoundaryEvents.clear();
        internalConnections.clear();
        externalSrcConnections.clear();
        externalTgtConnections.clear();

        IStructuredSelection strSelection = getStructuredSelection();
        for (Object editPart : strSelection.toList()) {
            if (editPart instanceof GraphicalEditPart &&
                    !(editPart instanceof Activity2EditPart)) {
                //this will not take into account the selected connections
                editParts.add((GraphicalEditPart) editPart);
            }
        }

        EditPart parentContainer = null;
        Iterator<GraphicalEditPart> iterator = editParts.iterator();
        boolean onlyArtifacts = true;
        while (iterator.hasNext()) {
            GraphicalEditPart editPart = iterator.next();
            EditPart container = editPart.getParent();
            if (!(editPart.resolveSemanticElement() instanceof Artifact)) {
            	onlyArtifacts = false;
            }
            if (editPart instanceof LaneEditPart
                    || !(container instanceof PoolPoolCompartmentEditPart)
                    && !(container instanceof SubProcessSubProcessBodyCompartmentEditPart)) {
                editParts.clear();
                almostSelectedBoundaryEvents.clear();
                break;
            }
            if (container instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                if (isInsideAnother(container, editParts)) {
                    iterator.remove();
                    continue;
                }
            }
            if (editPart instanceof SubProcessEditPart) {
                //add the boundary events to the selection
                SubProcessSubProcessBorderCompartmentEditPart borderEditPart =
                    (SubProcessSubProcessBorderCompartmentEditPart)
                ((SubProcessEditPart)editPart)
                    .getChildBySemanticHintOnPrimaryView(
                            SubProcessSubProcessBorderCompartmentEditPart.VISUAL_ID + "");
                for (Object child : borderEditPart.getChildren()) {
                    if (child instanceof Activity2EditPart) {
                        almostSelectedBoundaryEvents.add((IGraphicalEditPart) child);
                    }
                }
            }
            
           
            if (parentContainer == null) {
                parentContainer = container;
            } else if (parentContainer != container) {
                editParts.clear();
                almostSelectedBoundaryEvents.clear();
                break;
            }
        }
        if (onlyArtifacts) {
        	editParts.clear();
        }
//        //group is not enabled if 1 or less edit parts are selected
//        //always group more than one edit part.
//        if (editParts.size() == 1) {
//            editParts.clear();
//            almostSelectedBoundaryEvents.clear();
//        }

        for (IGraphicalEditPart editPart : editParts) {
            sortConnections(editPart, internalConnections,
                    externalSrcConnections, externalTgtConnections);
        }

        EditPart element = null;
        for (SequenceEdgeEditPart connection : externalSrcConnections) {
            EditPart currElement = connection.getSource();
            if (element == null) {
                element = currElement;
            } else if (element != currElement) {
                setEnabled(false);
                return;
            }
        }
        element = null;
        for (SequenceEdgeEditPart connection : externalTgtConnections) {
            EditPart currElement = connection.getTarget();
            if (element == null) {
                element = currElement;
            } else if (element != currElement) {
                setEnabled(false);
                return;
            }
        }

        for (GraphicalEditPart editPart : editParts) {
        	if (lookForIgnoredSequenceMembers(editPart, false, new HashSet<EditPart>())) {
        		editParts.clear();
        		break;
        	}
        }
        setEnabled(!editParts.isEmpty());
    }

    /**
     * Detects that a task is in the sequence, ignored in the selection
     * @param editPart the edit part to follow
     * @param metIgnoredShapes if already detected an ignored shape
     * @return true if there was an edit part ignored between 
     * two selected edit parts
     * 
     * 
     */
    private boolean lookForIgnoredSequenceMembers(GraphicalEditPart editPart, 
    		boolean metIgnoredShapes, Set<EditPart>  visited) {
    	visited.add(editPart);
    	boolean foundIgnored = false;
		for (Object connection : editPart.getTargetConnections()) {
			if (connection instanceof SequenceEdgeEditPart) {
				GraphicalEditPart part = (GraphicalEditPart) ((ConnectionEditPart) 
							connection).getSource();
				if (editParts.contains(part)) {
					if (metIgnoredShapes) {
						return true;
					}
				} else {
					metIgnoredShapes = true;
				}
				if (visited.contains(part)) {
					return false;
				}
				foundIgnored = foundIgnored || lookForIgnoredSequenceMembers(
						part, metIgnoredShapes, visited);
			}
		}
		return foundIgnored;
	}

	/**
     * Determines whether specified edit part is a child of ony other edit part
     * (in undefined depth)
     * 
     * @param editPart
     *            the edit part to test
     * @param editParts
     *            other edit parts
     * @return <code>true</code> if specified edit part is child of ony other
     *         edit part (in undefined depth), <code>false</code> otherwise.
     */
    private static boolean isInsideAnother(EditPart editPart, List editParts) {
        SubProcessEditPart subProcess = getSubProcess(editPart);
        while (subProcess != null) {
            if (editParts.contains(subProcess)) {
                return true;
            }
            subProcess = getSubProcess(subProcess.getParent());
        }
        return false;
    }

}