/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Set;

import org.eclipse.osgi.util.NLS;

public class UnreleasedScribblerException extends Exception {

   public static Set         exceptions;

   /**
    * Comment for <code>serialVersionUID</code>
    */
   private static final long serialVersionUID = 7222303066370234692L;

   public UnreleasedScribblerException(String theEditModelLabel) {
      super(NLS.bind(Messages.An_IEditModelScribbler_fo_, theEditModelLabel));
      if (exceptions != null)
         exceptions.add(this);
   }

   public void printStackTrace(PrintStream s) {
      s.println(Messages.The_following_trace_is_a_);
      super.printStackTrace(s);
   }

   public void printStackTrace(PrintWriter s) {
      s.println(Messages.The_following_trace_is_a_);
      super.printStackTrace(s);
   }
}
