/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.ui.contribution;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.ui.IWorkbenchPart;

/**
 * 
 * Handles requests made to the encompassing editor
 * 
 */

public interface IEditorHandler {
	/**
	 * Instructs the editor to run the operation.  The operation is run from the editor's command stack, which supports Undo.
	 * Contributions to the property pages should not update the SCA model or any of its extensions directly.  Instead,
	 * they should wrap the model updates in an operation and call this method to run the operation.  Direct updates to the model
	 * do not integrate with the editors' undo stack; updates done by an operation do integrate.
	 * 
	 * @param operation - the operation to run.
	 */
	public void execute(IUndoableOperation operation);
	/**
	 * Instructs the editor to report the error in the normal place that the editor reports errors.  This method can be used
	 * to report errors in fields that the user changes as the user types (for example, by a keyListener).
	 * Only the last reported error is shown at any point in time.
	 * 
	 * @param error - The error to display.  This string must be in the appropriate locale of the user.
	 */
	public void reportError(String error);
	
	/**
	 * Instructs the editor to clear any errors it may currently be reporting.
	 */
	public void clearError();
	
	/**
	 * Returns the Workbench part for the editor
	 * 
	 * @return the {@link IWorkbenchPart} for the editor
	 */
	public IWorkbenchPart getWorkbenchPart();
}
