/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class DeleteRootSCAModelDataModelProvider extends
      AbstractScribblerDataModelProvider implements
      IDeleteRootSCAModelDataModelProperties {

   public IStatus validate(String name) {
      if (name.equals(SCAOBJECT_TO_DELETE))
         return validateSCAObjectToDelete();

      return super.validate(name);
   }

   public DeleteRootSCAModelDataModelProvider() {
      super();
   }

   public IDataModelOperation getDefaultOperation() {
      return new DeleteRootSCAModelOperation(model);
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider#getPropertyNames()
    */
   public Set getPropertyNames() {
      Set propertyNames = super.getPropertyNames();
      propertyNames.add(SCAOBJECT_TO_DELETE);

      return propertyNames;
   }

   private IStatus validateSCAObjectToDelete() {
      // SCAObject scaObjectToDelete =
      // (SCAObject)getProperty(SCAOBJECT_TO_DELETE);
      // if (!(eObjectToDelete instanceof Part || eObjectToDelete instanceof
      // ReferenceSet))
      // return
      // STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText,
      // null);
      //		
      return OK_STATUS;
   }
}
